/*****************************************************************************************
*                                                                                        *
* This SAS program will extract the United States Sentencing Commission's Overdoses in   *
* Federal Drug Trafficking Crimes 2025 report victim file and create a SAS dataset.      *
*                                                                                        *
* Prior to running the program you must update the DAT file location in the FILNAME line *
* to correspond to the location of the file on your computer.                            *
*                                                                                        *
* You must also update the library location in the LIBNAME statement to correspond to    *
* the folder you want the output file to be located.                                     *
*                                                                                        *
*****************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile '.\ussc_od_rep_2025_vict_public.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library '.' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = ussc_od_rep_2025_vict_public ;

DATA library.&dataset ;
INFILE datafile LRECL=22;
INPUT
   USSCIDN  1-7             DIRECTDIST  8-10         VICDIED  11           
   VICSEX  12-14            VICLOC  15               DRUGGROUP  16         
   VICBOUGHT  17-21         VICDRUGGROUP  22       ;                       

LENGTH
   USSCIDN 6                DIRECTDIST 4             VICDIED 3             
   VICSEX 4                 VICLOC 3                 DRUGGROUP 3           
   VICBOUGHT 6              VICDRUGGROUP 3 ;

    

RUN ;
