/*****************************************************************************************
*                                                                                        *
* This SAS program will extract the United States Sentencing Commission's Overdoses in   *
* Federal Drug Trafficking Crimes 2025 report sentenced individual file and create a SAS *
* dataset.                                                                               *
*                                                                                        *
* Prior to running the program you must update the DAT file location in the FILNAME line *
* to correspond to the location of the file on your computer.                            *
*                                                                                        *
* You must also update the library location in the LIBNAME statement to correspond to    *
* the folder you want the output file to be located.                                     *
*                                                                                        *
*****************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile '.\ussc_od_rep_2025_ind_public.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library '.' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = ussc_od_rep_2025_ind_public ;

DATA library.&dataset ;
INFILE datafile LRECL=97;
INPUT
   SENSPCAP  1-6            USSCIDN  7-13            AGE  14-15            
   CIRCDIST  16-17          COMBDRG2  18-19          MONSEX  20            
   NEWCIT  21               NEWEDUC  22              NEWRACE  23           
   SENTIMP  24              TOTCHPTS  25-26          XCRHISSR  27          
   DRUGMIN  28-31           DRUGTYP1  32-34          METHMIN  35-37        
   BASEHI  38-39            FY  40-43                UNCAPBOL  44-45       
   TYPE  46                 RELIEF_OD  47            RELIEFDUM  48         
   DEPVARPIE1  49           DEFMEDICAL  50           DEFMISREP  51-53      
   DEFAID  54-56            DEFNOAID  57-59          DEFHARM  60-62        
   DEFUSE  63-65            DEFTHERE  66-68          FUNCSER  69-70        
   NUMINJ  71-73            NUMDEAD  74-76           CODEDVICTIMS  77-78   
   OVERDOSE  79             NOODINCREASE  80         PRIMARYOD  81         
   VICOUTCOME  82           VICCOUNT  83             MINCAT  84            
   BOL  85                  APPCAT  86               NUMINJ2  87-88        
   NUMDEAD2  89-90          VICOUTCOME2  91          GLMIN  92-97          
 ;                       

LENGTH
   USSCIDN 6                AGE 3                    CIRCDIST 3            
   COMBDRG2 3               MONSEX 3                 NEWCIT 3              
   NEWEDUC 3                NEWRACE 3                SENTIMP 3             
   TOTCHPTS 3               XCRHISSR 3               DRUGMIN 4             
   DRUGTYP1 4               METHMIN 4                BASEHI 3              
   FY 4                     UNCAPBOL 3               TYPE 3                
   RELIEF_OD 3              RELIEFDUM 3              DEPVARPIE1 3          
   DEFMEDICAL 3             DEFMISREP 4              DEFAID 4              
   DEFNOAID 4               DEFHARM 4                DEFUSE 4              
   DEFTHERE 4               FUNCSER 3                NUMINJ 4              
   NUMDEAD 4                CODEDVICTIMS 3           OVERDOSE 3            
   NOODINCREASE 3           PRIMARYOD 3              VICOUTCOME 3          
   VICCOUNT 3               MINCAT 3                 BOL 3                 
   APPCAT 3                 NUMINJ2 3                NUMDEAD2 3            
   VICOUTCOME2 3 ;

     

RUN ;
