/*****************************************************************************************
*                                                                                        *
* This SAS program will extract the United States Sentencing Commission's 2020 Economic  *
* Crime Offense Type data file and create a SAS dataset.                                 *
*                                                                                        *
* Prior to running the program you must update the DAT file location in the FILNAME line *
* to correspond to the location of the file on your computer.                            *
*                                                                                        *
* You must also update the library location in the LIBNAME statement to correspond to    *
* the folder you want the output file to be located.                                     *
*                                                                                        *
*****************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile '.\econ20.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library '.' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = econ20 ;

DATA library.&dataset ;
INFILE datafile LRECL=9;
INPUT
   USSCIDN  1-7             ECON_OFF_TYPE  8-9     ;                       

LABEL
   USSCIDN = "USSCIDN"
;

LENGTH
   USSCIDN 6                ECON_OFF_TYPE 3 ;

   

RUN ;
