* Encoding: windows-1252.
/************************************************************************************************************/
/*                                                                                                                                     */
/* This SAS program will extract the United States Sentencing Commission's 21 U.S.C.  851*/
/* Enhanced Drug Penalty Fiscal Year 2020 file and create a SAS dataset.                           */
/*                                                                                                                                    */
/* Prior to running the program you must update the DAT file location in the FILNAME line      */
/* to correspond to the location of the file on your computer.                                                 */
/*                                                                                                                                    */
/* You must also update the library location in the LIBNAME statement to correspond to       */
/* the folder you want the output file to be located.                                                              */
/*                                                                                                                                   */
/***********************************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
/* The last line of this file contains the path to your output '.sav' file */

FILE HANDLE DATA / NAME=".\drug851fy20nid.dat" ENCODING="CP1252" / LRECL=363 .

DATA LIST FILE=DATA/
   USSCIDN 1-7              STMIN851 8-11            STMAX851 12-15        
   DGMIN851 16-19           DGMAX851 20-23           FILED 24-26           
   WITHDRWN 27-29           RELIEF 30-32             CTRELIEF 33-35        
   CRMHT851 36-38           INDTDATE 39-49 (DATE)    FILEDATE 50-60 (DATE) 
   PROFFN1 61-64            PROFFN2 65-68            PROFFN3 69-72         
   PROFFN4 73-76            PROFFN5 77-80            PROFFN6 81-84         
   PROFFN7 85-88            PROFFN8 89-92            PROFFN9 93-96         
   PROFFN10 97-100          PROFFN11 101-104         PROFFN12 105-108      
   PRSENT1 109-112          PRSENT2 113-116          PRSENT3 117-120       
   PRSENT4 121-124          PRSENT5 125-128          PRSENT6 129-132       
   PRSENT7 133-136          PRSENT8 137-140          PRSENT9 141-144       
   PRSENT10 145-148         PRSENT11 149-152         PRSENT12 153-156      
   PRSNDT1 157-167 (DATE)   PRSNDT2 168-178 (DATE)   PRSNDT3 179-189 (DATE)
   PRSNDT4 190-200 (DATE)   PRSNDT5 201-211 (DATE)   PRSNDT6 212-222 (DATE)
   PRSNDT7 223-233 (DATE)   PRSNDT8 234-244 (DATE)   PRSNDT9 245-255 (DATE)
   PRSNDT10 256-266 (DATE)   PRSNDT11 267-277 (DATE)   PRSNDT12 278-288 (DATE)
   OFFENNUM 289-291         PRCHPT1 292-294          PRCHPT2 295-297       
   PRCHPT3 298-300          PRCHPT4 301-303          PRCHPT5 304-306       
   PRCHPT6 307-309          PRCHPT7 310-312          PRCHPT8 313-315       
   PRCHPT9 316-318          PRCHPT10 319-321         PRCHPT11 322-324      
   PRCHPT12 325-327         PRFELN1 328-330          PRFELN2 331-333       
   PRFELN3 334-336          PRFELN4 337-339          PRFELN5 340-342       
   PRFELN6 343-345          PRFELN7 346-348          PRFELN8 349-351       
   PRFELN9 352-354          PRFELN10 355-357         PRFELN11 358-360      
   PRFELN12 361-363 .    


SAVE OUTFILE='.\drug851fy20nid.sav'.
