/*****************************************************************************************
*                                                                                        *
* This SAS program will extract the United States Sentencing Commission's 21 U.S.C.  851*
* Enhanced Drug Penalty Fiscal Year 2020 file and create a SAS dataset.                  *
*                                                                                        *
* Prior to running the program you must update the DAT file location in the FILNAME line *
* to correspond to the location of the file on your computer.                            *
*                                                                                        *
* You must also update the library location in the LIBNAME statement to correspond to    *
* the folder you want the output file to be located.                                     *
*                                                                                        *
*****************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile '.\drug851fy20nid.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library '.' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = drug851fy20nid ;

DATA library.&dataset ;
INFILE datafile LRECL=363;
INPUT
   USSCIDN  1-7             STMIN851  8-11           STMAX851  12-15       
   DGMIN851  16-19          DGMAX851  20-23          FILED  24-26          
   WITHDRWN  27-29          RELIEF  30-32            CTRELIEF  33-35       
   CRMHT851  36-38          INDTDATE DATE11.         FILEDATE DATE11.      
   PROFFN1  61-64           PROFFN2  65-68           PROFFN3  69-72        
   PROFFN4  73-76           PROFFN5  77-80           PROFFN6  81-84        
   PROFFN7  85-88           PROFFN8  89-92           PROFFN9  93-96        
   PROFFN10  97-100         PROFFN11  101-104        PROFFN12  105-108     
   PRSENT1  109-112         PRSENT2  113-116         PRSENT3  117-120      
   PRSENT4  121-124         PRSENT5  125-128         PRSENT6  129-132      
   PRSENT7  133-136         PRSENT8  137-140         PRSENT9  141-144      
   PRSENT10  145-148        PRSENT11  149-152        PRSENT12  153-156     
   PRSNDT1 DATE11.          PRSNDT2 DATE11.          PRSNDT3 DATE11.       
   PRSNDT4 DATE11.          PRSNDT5 DATE11.          PRSNDT6 DATE11.       
   PRSNDT7 DATE11.          PRSNDT8 DATE11.          PRSNDT9 DATE11.       
   PRSNDT10 DATE11.         PRSNDT11 DATE11.         PRSNDT12 DATE11.      
   OFFENNUM  289-291        PRCHPT1  292-294         PRCHPT2  295-297      
   PRCHPT3  298-300         PRCHPT4  301-303         PRCHPT5  304-306      
   PRCHPT6  307-309         PRCHPT7  310-312         PRCHPT8  313-315      
   PRCHPT9  316-318         PRCHPT10  319-321        PRCHPT11  322-324     
   PRCHPT12  325-327        PRFELN1  328-330         PRFELN2  331-333      
   PRFELN3  334-336         PRFELN4  337-339         PRFELN5  340-342      
   PRFELN6  343-345         PRFELN7  346-348         PRFELN8  349-351      
   PRFELN9  352-354         PRFELN10  355-357        PRFELN11  358-360     
   PRFELN12  361-363      ;                       

FORMAT
   INDTDATE DATE9.          FILEDATE DATE9.          PRSNDT1 DATE9.        
   PRSNDT2 DATE9.           PRSNDT3 DATE9.           PRSNDT4 DATE9.        
   PRSNDT5 DATE9.           PRSNDT6 DATE9.           PRSNDT7 DATE9.        
   PRSNDT8 DATE9.           PRSNDT9 DATE9.           PRSNDT10 DATE9.       
   PRSNDT11 DATE9.          PRSNDT12 DATE9.        ;
                      

LENGTH
   USSCIDN 6                STMIN851 4               STMAX851 4            
   DGMIN851 4               DGMAX851 4               FILED 3               
   WITHDRWN 3               RELIEF 3                 CTRELIEF 3            
   CRMHT851 3               PROFFN1 4                PROFFN2 4             
   PROFFN3 4                PROFFN4 4                PROFFN5 4             
   PROFFN6 4                PROFFN7 4                PROFFN8 4             
   PROFFN9 4                PROFFN10 4               PROFFN11 4            
   PROFFN12 4               PRSENT1 4                PRSENT2 4             
   PRSENT3 4                PRSENT4 4                PRSENT5 4             
   PRSENT6 4                PRSENT7 4                PRSENT8 4             
   PRSENT9 4                PRSENT10 4               PRSENT11 4            
   PRSENT12 3               OFFENNUM 3               PRCHPT1 3             
   PRCHPT2 3                PRCHPT3 3                PRCHPT4 3             
   PRCHPT5 3                PRCHPT6 3                PRCHPT7 3             
   PRCHPT8 3                PRCHPT9 3                PRCHPT10 3            
   PRCHPT11 3               PRCHPT12 3               PRFELN1 3             
   PRFELN2 3                PRFELN3 3                PRFELN4 3             
   PRFELN5 3                PRFELN6 3                PRFELN7 3             
   PRFELN8 3                PRFELN9 3                PRFELN10 3            
   PRFELN11 3               PRFELN12 3 ;

        

RUN ;
