* Encoding: windows-1252.
/*********************************************************************************************************/
/*                                                                                                                                 */
/* This SPSS program will extract the United States Sentencing Commission's fiscal year  */
/* 2017 Criminal History file and create a SPSS dataset.                                                  */
/*                                                                                                                                 */
/* Prior to running the program you must update the DAT file location in the                       */
/* FILE HANDLE DATA / NAME line to correspond to the location of the file on your           */
/* computer, replacing the '.' with the folder path location (e.g. 'C:\temp').                            */
/*                                                                                                                                 */
/* You must also update the file output location in the SAVE OUTFILE statement at the     */
/* end of the program to correspond to the folder you want the output file to be located,      */
/* replacing the '.' with the folder path location (e.g. 'C:\temp') .                                          */
/*                                                                                                                                 */
/*********************************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
/* The last line of this file contains the path to your output '.sav' file */

FILE HANDLE DATA / NAME=".\crimhist17nid.dat" ENCODING="CP1252" / LRECL=10114 .

DATA LIST FILE=DATA/
   USSCIDN 1-7              CHARDT1 8-18 (DATE)      CHARDT2 19-29 (DATE)  
   CHARDT3 30-40 (DATE)     CHARDT4 41-51 (DATE)     CHARDT5 52-62 (DATE)  
   CHARDT6 63-73 (DATE)     CHARDT7 74-84 (DATE)     CHARDT8 85-95 (DATE)  
   CHARDT9 96-106 (DATE)    CHARDT10 107-117 (DATE)   CHARDT11 118-128 (DATE)
   CHARDT12 129-139 (DATE)   CHARDT13 140-150 (DATE)   CHARDT14 151-161 (DATE)
   CHARDT15 162-172 (DATE)   CHARDT16 173-183 (DATE)   CHARDT17 184-194 (DATE)
   CHARDT18 195-205 (DATE)   CHARDT19 206-216 (DATE)   CHARDT20 217-227 (DATE)
   CHARDT21 228-238 (DATE)   CHARDT22 239-249 (DATE)   CHARDT23 250-260 (DATE)
   CHARDT24 261-271 (DATE)   CHARDT25 272-282 (DATE)   CHARDT26 283-293 (DATE)
   CHARDT27 294-304 (DATE)   CHARDT28 305-315 (DATE)   CHARDT29 316-326 (DATE)
   CHARDT30 327-337 (DATE)   CHARDT31 338-348 (DATE)   CHARDT32 349-359 (DATE)
   CHARDT33 360-370 (DATE)   CHARDT34 371-381 (DATE)   CHARDT35 382-392 (DATE)
   CHARDT36 393-403 (DATE)   CHARDT37 404-414 (DATE)   CHARDT38 415-425 (DATE)
   CHARDT39 426-436 (DATE)   CHARDT40 437-447 (DATE)   CHARDT41 448-458 (DATE)
   CHARDT42 459-469 (DATE)   CHARDT43 470-480 (DATE)   CHARDT44 481-491 (DATE)
   CHARDT45 492-502 (DATE)   CHARDT46 503-513 (DATE)   CHARDT47 514-524 (DATE)
   CHARDT48 525-535 (DATE)   CHARDT49 536-546 (DATE)   CHARDT50 547-557 (DATE)
   CHARDT51 558-568 (DATE)   CHARDT52 569-579 (DATE)   CHARDT53 580-590 (DATE)
   CHARDT54 591-601 (DATE)   CHARDT55 602-612 (DATE)   CHARDT56 613-623 (DATE)
   CHARDT57 624-634 (DATE)   CHARDT58 635-645 (DATE)   CHARDT59 646-656 (DATE)
   CHARDT60 657-667 (DATE)   CHARDT61 668-678 (DATE)   CHARDT62 679-689 (DATE)
   CHARDT63 690-700 (DATE)   CHARDT64 701-711 (DATE)   CHARDT65 712-722 (DATE)
   CHARDT66 723-733 (DATE)   CHARDT67 734-744 (DATE)   CHARDT68 745-755 (DATE)
   CHARDT69 756-766 (DATE)   CHARDT70 767-777 (DATE)   CHARDT71 778-788 (DATE)
   CHARDT72 789-799 (DATE)   CHARDT73 800-810 (DATE)   CHARDT74 811-821 (DATE)
   CHARDT75 822-832 (DATE)   CHARDT76 833-843 (DATE)   CHARDT77 844-854 (DATE)
   CHARDT78 855-865 (DATE)   CHARDT79 866-876 (DATE)   CHARDT80 877-887 (DATE)
   CHARDT81 888-898 (DATE)   CHARDT82 899-909 (DATE)   CHARDT83 910-920 (DATE)
   CHARDT84 921-931 (DATE)   CHARDT85 932-942 (DATE)   CHARDT86 943-953 (DATE)
   CHARDT87 954-964 (DATE)   CHARDT88 965-975 (DATE)   CHARDT89 976-986 (DATE)
   CHARDT90 987-997 (DATE)   CHARDT91 998-1008 (DATE)
   CHARDT92 1009-1019 (DATE)   CHARDT93 1020-1030 (DATE)
   CHARDT94 1031-1041 (DATE)   CHARDT95 1042-1052 (DATE)
   CHARDT96 1053-1063 (DATE)   CHARDT97 1064-1074 (DATE)
   CHARDT98 1075-1085 (DATE)   CHARDT99 1086-1096 (DATE)
   CHARDT100 1097-1107 (DATE)   CHARDT101 1108-1118 (DATE)
   CHARDT102 1119-1129 (DATE)   CHARDT103 1130-1140 (DATE)
   CHARDT104 1141-1151 (DATE)   CHARDT105 1152-1162 (DATE)
   CHARDT106 1163-1173 (DATE)   CHARDT107 1174-1184 (DATE)
   CHARDT108 1185-1195 (DATE)   CHARDT109 1196-1206 (DATE)
   CHARDT110 1207-1217 (DATE)   CHARDT111 1218-1228 (DATE)
   CHARDT112 1229-1239 (DATE)   CHARDT113 1240-1250 (DATE)
   CHARDT114 1251-1261 (DATE)   CHARDT115 1262-1272 (DATE)
   CHARDT116 1273-1283 (DATE)   CHARDT117 1284-1294 (DATE)
   CHARDT118 1295-1305 (DATE)   CHARDT119 1306-1316 (DATE)
   CHARDT120 1317-1327 (DATE)   CHSNDT1 1328-1338 (DATE)
   CHSNDT2 1339-1349 (DATE)   CHSNDT3 1350-1360 (DATE)
   CHSNDT4 1361-1371 (DATE)   CHSNDT5 1372-1382 (DATE)
   CHSNDT6 1383-1393 (DATE)   CHSNDT7 1394-1404 (DATE)
   CHSNDT8 1405-1415 (DATE)   CHSNDT9 1416-1426 (DATE)
   CHSNDT10 1427-1437 (DATE)   CHSNDT11 1438-1448 (DATE)
   CHSNDT12 1449-1459 (DATE)   CHSNDT13 1460-1470 (DATE)
   CHSNDT14 1471-1481 (DATE)   CHSNDT15 1482-1492 (DATE)
   CHSNDT16 1493-1503 (DATE)   CHSNDT17 1504-1514 (DATE)
   CHSNDT18 1515-1525 (DATE)   CHSNDT19 1526-1536 (DATE)
   CHSNDT20 1537-1547 (DATE)   CHSNDT21 1548-1558 (DATE)
   CHSNDT22 1559-1569 (DATE)   CHSNDT23 1570-1580 (DATE)
   CHSNDT24 1581-1591 (DATE)   CHSNDT25 1592-1602 (DATE)
   CHSNDT26 1603-1613 (DATE)   CHSNDT27 1614-1624 (DATE)
   CHSNDT28 1625-1635 (DATE)   CHSNDT29 1636-1646 (DATE)
   CHSNDT30 1647-1657 (DATE)   CHSNDT31 1658-1668 (DATE)
   CHSNDT32 1669-1679 (DATE)   CHSNDT33 1680-1690 (DATE)
   CHSNDT34 1691-1701 (DATE)   CHSNDT35 1702-1712 (DATE)
   CHSNDT36 1713-1723 (DATE)   CHSNDT37 1724-1734 (DATE)
   CHSNDT38 1735-1745 (DATE)   CHSNDT39 1746-1756 (DATE)
   CHSNDT40 1757-1767 (DATE)   CHSNDT41 1768-1778 (DATE)
   CHSNDT42 1779-1789 (DATE)   CHSNDT43 1790-1800 (DATE)
   CHSNDT44 1801-1811 (DATE)   CHSNDT45 1812-1822 (DATE)
   CHSNDT46 1823-1833 (DATE)   CHSNDT47 1834-1844 (DATE)
   CHSNDT48 1845-1855 (DATE)   CHSNDT49 1856-1866 (DATE)
   CHSNDT50 1867-1877 (DATE)   CHSNDT51 1878-1888 (DATE)
   CHSNDT52 1889-1899 (DATE)   CHSNDT53 1900-1910 (DATE)
   CHSNDT54 1911-1921 (DATE)   CHSNDT55 1922-1932 (DATE)
   CHSNDT56 1933-1943 (DATE)   CHSNDT57 1944-1954 (DATE)
   CHSNDT58 1955-1965 (DATE)   CHSNDT59 1966-1976 (DATE)
   CHSNDT60 1977-1987 (DATE)   CHSNDT61 1988-1998 (DATE)
   CHSNDT62 1999-2009 (DATE)   CHSNDT63 2010-2020 (DATE)
   CHSNDT64 2021-2031 (DATE)   CHSNDT65 2032-2042 (DATE)
   CHSNDT66 2043-2053 (DATE)   CHSNDT67 2054-2064 (DATE)
   CHSNDT68 2065-2075 (DATE)   CHSNDT69 2076-2086 (DATE)
   CHSNDT70 2087-2097 (DATE)   CHSNDT71 2098-2108 (DATE)
   CHSNDT72 2109-2119 (DATE)   CHSNDT73 2120-2130 (DATE)
   CHSNDT74 2131-2141 (DATE)   CHSNDT75 2142-2152 (DATE)
   CHSNDT76 2153-2163 (DATE)   CHSNDT77 2164-2174 (DATE)
   CHSNDT78 2175-2185 (DATE)   CHSNDT79 2186-2196 (DATE)
   CHSNDT80 2197-2207 (DATE)   CHSNDT81 2208-2218 (DATE)
   CHSNDT82 2219-2229 (DATE)   CHSNDT83 2230-2240 (DATE)
   CHSNDT84 2241-2251 (DATE)   CHSNDT85 2252-2262 (DATE)
   CHSNDT86 2263-2273 (DATE)   CHSNDT87 2274-2284 (DATE)
   CHSNDT88 2285-2295 (DATE)   CHSNDT89 2296-2306 (DATE)
   CHSNDT90 2307-2317 (DATE)   CHSNDT91 2318-2328 (DATE)
   CHSNDT92 2329-2339 (DATE)   CHSNDT93 2340-2350 (DATE)
   CHSNDT94 2351-2361 (DATE)   CHSNDT95 2362-2372 (DATE)
   CHSNDT96 2373-2383 (DATE)   CHSNDT97 2384-2394 (DATE)
   CHSNDT98 2395-2405 (DATE)   CHSNDT99 2406-2416 (DATE)
   CHSNDT100 2417-2427 (DATE)   CHSNDT101 2428-2438 (DATE)
   CHSNDT102 2439-2449 (DATE)   CHSNDT103 2450-2460 (DATE)
   CHSNDT104 2461-2471 (DATE)   CHSNDT105 2472-2482 (DATE)
   CHSNDT106 2483-2493 (DATE)   CHSNDT107 2494-2504 (DATE)
   CHSNDT108 2505-2515 (DATE)   CHSNDT109 2516-2526 (DATE)
   CHSNDT110 2527-2537 (DATE)   CHSNDT111 2538-2548 (DATE)
   CHSNDT112 2549-2559 (DATE)   CHSNDT113 2560-2570 (DATE)
   CHSNDT114 2571-2581 (DATE)   CHSNDT115 2582-2592 (DATE)
   CHSNDT116 2593-2603 (DATE)   CHSNDT117 2604-2614 (DATE)
   CHSNDT118 2615-2625 (DATE)   CHSNDT119 2626-2636 (DATE)
   CHSNDT120 2637-2647 (DATE)   EVENTNUM 2648-2650       CHPTS1 2651-2653      
   CHPTS2 2654-2656         CHPTS3 2657-2659         CHPTS4 2660-2662      
   CHPTS5 2663-2665         CHPTS6 2666-2668         CHPTS7 2669-2671      
   CHPTS8 2672-2674         CHPTS9 2675-2677         CHPTS10 2678-2680     
   CHPTS11 2681-2683        CHPTS12 2684-2686        CHPTS13 2687-2689     
   CHPTS14 2690-2692        CHPTS15 2693-2695        CHPTS16 2696-2698     
   CHPTS17 2699-2701        CHPTS18 2702-2704        CHPTS19 2705-2707     
   CHPTS20 2708-2710        CHPTS21 2711-2713        CHPTS22 2714-2716     
   CHPTS23 2717-2719        CHPTS24 2720-2722        CHPTS25 2723-2725     
   CHPTS26 2726-2728        CHPTS27 2729-2731        CHPTS28 2732-2734     
   CHPTS29 2735-2737        CHPTS30 2738-2740        CHPTS31 2741-2743     
   CHPTS32 2744-2746        CHPTS33 2747-2749        CHPTS34 2750-2752     
   CHPTS35 2753-2755        CHPTS36 2756-2758        CHPTS37 2759-2761     
   CHPTS38 2762-2764        CHPTS39 2765-2767        CHPTS40 2768-2770     
   CHPTS41 2771-2773        CHPTS42 2774-2776        CHPTS43 2777-2779     
   CHPTS44 2780-2782        CHPTS45 2783-2785        CHPTS46 2786-2788     
   CHPTS47 2789-2791        CHPTS48 2792-2794        CHPTS49 2795-2797     
   CHPTS50 2798-2800        CHPTS51 2801-2803        CHPTS52 2804-2806     
   CHPTS53 2807-2809        CHPTS54 2810-2812        CHPTS55 2813-2815     
   CHPTS56 2816-2818        CHPTS57 2819-2821        CHPTS58 2822-2824     
   CHPTS59 2825-2827        CHPTS60 2828-2830        CHPTS61 2831-2833     
   CHPTS62 2834-2836        CHPTS63 2837-2839        CHPTS64 2840-2842     
   CHPTS65 2843-2845        CHPTS66 2846-2848        CHPTS67 2849-2851     
   CHPTS68 2852-2854        CHPTS69 2855-2857        CHPTS70 2858-2860     
   CHPTS71 2861-2863        CHPTS72 2864-2866        CHPTS73 2867-2869     
   CHPTS74 2870-2872        CHPTS75 2873-2875        CHPTS76 2876-2878     
   CHPTS77 2879-2881        CHPTS78 2882-2884        CHPTS79 2885-2887     
   CHPTS80 2888-2890        CHPTS81 2891-2893        CHPTS82 2894-2896     
   CHPTS83 2897-2899        CHPTS84 2900-2902        CHPTS85 2903-2905     
   CHPTS86 2906-2908        CHPTS87 2909-2911        CHPTS88 2912-2914     
   CHPTS89 2915-2917        CHPTS90 2918-2920        CHPTS91 2921-2923     
   CHPTS92 2924-2926        CHPTS93 2927-2929        CHPTS94 2930-2932     
   CHPTS95 2933-2935        CHPTS96 2936-2938        CHPTS97 2939-2941     
   CHPTS98 2942-2944        CHPTS99 2945-2947        CHPTS100 2948-2950    
   CHPTS101 2951-2953       CHPTS102 2954-2956       CHPTS103 2957-2959    
   CHPTS104 2960-2962       CHPTS105 2963-2965       CHPTS106 2966-2968    
   CHPTS107 2969-2971       CHPTS108 2972-2974       CHPTS109 2975-2977    
   CHPTS110 2978-2980       CHPTS111 2981-2983       CHPTS112 2984-2986    
   CHPTS113 2987-2989       CHPTS114 2990-2992       CHPTS115 2993-2995    
   CHPTS116 2996-2998       CHPTS117 2999-3001       CHPTS118 3002-3004    
   CHPTS119 3005-3007       CHPTS120 3008-3010       CHOFF1_1 3011-3013    
   CHOFF1_2 3014-3016       CHOFF1_3 3017-3019       CHOFF1_4 3020-3022    
   CHOFF1_5 3023-3025       CHOFF1_6 3026-3028       CHOFF1_7 3029-3031    
   CHOFF1_8 3032-3034       CHOFF1_9 3035-3037       CHOFF1_10 3038-3040   
   CHOFF1_11 3041-3043      CHOFF1_12 3044-3046      CHOFF1_13 3047-3049   
   CHOFF1_14 3050-3052      CHOFF1_15 3053-3055      CHOFF1_16 3056-3058   
   CHOFF1_17 3059-3061      CHOFF1_18 3062-3064      CHOFF1_19 3065-3067   
   CHOFF1_20 3068-3070      CHOFF1_21 3071-3073      CHOFF1_22 3074-3076   
   CHOFF1_23 3077-3079      CHOFF1_24 3080-3082      CHOFF1_25 3083-3085   
   CHOFF1_26 3086-3088      CHOFF1_27 3089-3091      CHOFF1_28 3092-3094   
   CHOFF1_29 3095-3097      CHOFF1_30 3098-3100      CHOFF1_31 3101-3103   
   CHOFF1_32 3104-3106      CHOFF1_33 3107-3109      CHOFF1_34 3110-3112   
   CHOFF1_35 3113-3115      CHOFF1_36 3116-3118      CHOFF1_37 3119-3121   
   CHOFF1_38 3122-3124      CHOFF1_39 3125-3127      CHOFF1_40 3128-3130   
   CHOFF1_41 3131-3133      CHOFF1_42 3134-3136      CHOFF1_43 3137-3139   
   CHOFF1_44 3140-3142      CHOFF1_45 3143-3145      CHOFF1_46 3146-3148   
   CHOFF1_47 3149-3151      CHOFF1_48 3152-3154      CHOFF1_49 3155-3157   
   CHOFF1_50 3158-3160      CHOFF1_51 3161-3163      CHOFF1_52 3164-3166   
   CHOFF1_53 3167-3169      CHOFF1_54 3170-3172      CHOFF1_55 3173-3175   
   CHOFF1_56 3176-3178      CHOFF1_57 3179-3181      CHOFF1_58 3182-3184   
   CHOFF1_59 3185-3187      CHOFF1_60 3188-3190      CHOFF1_61 3191-3193   
   CHOFF1_62 3194-3196      CHOFF1_63 3197-3199      CHOFF1_64 3200-3202   
   CHOFF1_65 3203-3205      CHOFF1_66 3206-3208      CHOFF1_67 3209-3211   
   CHOFF1_68 3212-3214      CHOFF1_69 3215-3217      CHOFF1_70 3218-3220   
   CHOFF1_71 3221-3223      CHOFF1_72 3224-3226      CHOFF1_73 3227-3229   
   CHOFF1_74 3230-3232      CHOFF1_75 3233-3235      CHOFF1_76 3236-3238   
   CHOFF1_77 3239-3241      CHOFF1_78 3242-3244      CHOFF1_79 3245-3247   
   CHOFF1_80 3248-3250      CHOFF1_81 3251-3253      CHOFF1_82 3254-3256   
   CHOFF1_83 3257-3259      CHOFF1_84 3260-3262      CHOFF1_85 3263-3265   
   CHOFF1_86 3266-3268      CHOFF1_87 3269-3271      CHOFF1_88 3272-3274   
   CHOFF1_89 3275-3277      CHOFF1_90 3278-3280      CHOFF1_91 3281-3283   
   CHOFF1_92 3284-3286      CHOFF1_93 3287-3289      CHOFF1_94 3290-3292   
   CHOFF1_95 3293-3295      CHOFF1_96 3296-3298      CHOFF1_97 3299-3301   
   CHOFF1_98 3302-3304      CHOFF1_99 3305-3307      CHOFF1_100 3308-3310  
   CHOFF1_101 3311-3313     CHOFF1_102 3314-3316     CHOFF1_103 3317-3319  
   CHOFF1_104 3320-3322     CHOFF1_105 3323-3325     CHOFF1_106 3326-3328  
   CHOFF1_107 3329-3331     CHOFF1_108 3332-3334     CHOFF1_109 3335-3337  
   CHOFF1_110 3338-3340     CHOFF1_111 3341-3343     CHOFF1_112 3344-3346  
   CHOFF1_113 3347-3349     CHOFF1_114 3350-3352     CHOFF1_115 3353-3355  
   CHOFF1_116 3356-3358     CHOFF1_117 3359-3361     CHOFF1_118 3362-3364  
   CHOFF1_119 3365-3367     CHOFF1_120 3368-3370     CHOFF2_1 3371-3373    
   CHOFF2_2 3374-3376       CHOFF2_3 3377-3379       CHOFF2_4 3380-3382    
   CHOFF2_5 3383-3385       CHOFF2_6 3386-3388       CHOFF2_7 3389-3391    
   CHOFF2_8 3392-3394       CHOFF2_9 3395-3397       CHOFF2_10 3398-3400   
   CHOFF2_11 3401-3403      CHOFF2_12 3404-3406      CHOFF2_13 3407-3409   
   CHOFF2_14 3410-3412      CHOFF2_15 3413-3415      CHOFF2_16 3416-3418   
   CHOFF2_17 3419-3421      CHOFF2_18 3422-3424      CHOFF2_19 3425-3427   
   CHOFF2_20 3428-3430      CHOFF2_21 3431-3433      CHOFF2_22 3434-3436   
   CHOFF2_23 3437-3439      CHOFF2_24 3440-3442      CHOFF2_25 3443-3445   
   CHOFF2_26 3446-3448      CHOFF2_27 3449-3451      CHOFF2_28 3452-3454   
   CHOFF2_29 3455-3457      CHOFF2_30 3458-3460      CHOFF2_31 3461-3463   
   CHOFF2_32 3464-3466      CHOFF2_33 3467-3469      CHOFF2_34 3470-3472   
   CHOFF2_35 3473-3475      CHOFF2_36 3476-3478      CHOFF2_37 3479-3481   
   CHOFF2_38 3482-3484      CHOFF2_39 3485-3487      CHOFF2_40 3488-3490   
   CHOFF2_41 3491-3493      CHOFF2_42 3494-3496      CHOFF2_43 3497-3499   
   CHOFF2_44 3500-3502      CHOFF2_45 3503-3505      CHOFF2_46 3506-3508   
   CHOFF2_47 3509-3511      CHOFF2_48 3512-3514      CHOFF2_49 3515-3517   
   CHOFF2_50 3518-3520      CHOFF2_51 3521-3523      CHOFF2_52 3524-3526   
   CHOFF2_53 3527-3529      CHOFF2_54 3530-3532      CHOFF2_55 3533-3535   
   CHOFF2_56 3536-3538      CHOFF2_57 3539-3541      CHOFF2_58 3542-3544   
   CHOFF2_59 3545-3547      CHOFF2_60 3548-3550      CHOFF2_61 3551-3553   
   CHOFF2_62 3554-3556      CHOFF2_63 3557-3559      CHOFF2_64 3560-3562   
   CHOFF2_65 3563-3565      CHOFF2_66 3566-3568      CHOFF2_67 3569-3571   
   CHOFF2_68 3572-3574      CHOFF2_69 3575-3577      CHOFF2_70 3578-3580   
   CHOFF2_71 3581-3583      CHOFF2_72 3584-3586      CHOFF2_73 3587-3589   
   CHOFF2_74 3590-3592      CHOFF2_75 3593-3595      CHOFF2_76 3596-3598   
   CHOFF2_77 3599-3601      CHOFF2_78 3602-3604      CHOFF2_79 3605-3607   
   CHOFF2_80 3608-3610      CHOFF2_81 3611-3613      CHOFF2_82 3614-3616   
   CHOFF2_83 3617-3619      CHOFF2_84 3620-3622      CHOFF2_85 3623-3625   
   CHOFF2_86 3626-3628      CHOFF2_87 3629-3631      CHOFF2_88 3632-3634   
   CHOFF2_89 3635-3637      CHOFF2_90 3638-3640      CHOFF2_91 3641-3643   
   CHOFF2_92 3644-3646      CHOFF2_93 3647-3649      CHOFF2_94 3650-3652   
   CHOFF2_95 3653-3655      CHOFF2_96 3656-3658      CHOFF2_97 3659-3661   
   CHOFF2_98 3662-3664      CHOFF2_99 3665-3667      CHOFF2_100 3668-3670  
   CHOFF2_101 3671-3673     CHOFF2_102 3674-3676     CHOFF2_103 3677-3679  
   CHOFF2_104 3680-3682     CHOFF2_105 3683-3685     CHOFF2_106 3686-3688  
   CHOFF2_107 3689-3691     CHOFF2_108 3692-3694     CHOFF2_109 3695-3697  
   CHOFF2_110 3698-3700     CHOFF2_111 3701-3703     CHOFF2_112 3704-3706  
   CHOFF2_113 3707-3709     CHOFF2_114 3710-3712     CHOFF2_115 3713-3715  
   CHOFF2_116 3716-3718     CHOFF2_117 3719-3721     CHOFF2_118 3722-3724  
   CHOFF2_119 3725-3727     CHOFF2_120 3728-3730     CHOFF3_1 3731-3733    
   CHOFF3_2 3734-3736       CHOFF3_3 3737-3739       CHOFF3_4 3740-3742    
   CHOFF3_5 3743-3745       CHOFF3_6 3746-3748       CHOFF3_7 3749-3751    
   CHOFF3_8 3752-3754       CHOFF3_9 3755-3757       CHOFF3_10 3758-3760   
   CHOFF3_11 3761-3763      CHOFF3_12 3764-3766      CHOFF3_13 3767-3769   
   CHOFF3_14 3770-3772      CHOFF3_15 3773-3775      CHOFF3_16 3776-3778   
   CHOFF3_17 3779-3781      CHOFF3_18 3782-3784      CHOFF3_19 3785-3787   
   CHOFF3_20 3788-3790      CHOFF3_21 3791-3793      CHOFF3_22 3794-3796   
   CHOFF3_23 3797-3799      CHOFF3_24 3800-3802      CHOFF3_25 3803-3805   
   CHOFF3_26 3806-3808      CHOFF3_27 3809-3811      CHOFF3_28 3812-3814   
   CHOFF3_29 3815-3817      CHOFF3_30 3818-3820      CHOFF3_31 3821-3823   
   CHOFF3_32 3824-3826      CHOFF3_33 3827-3829      CHOFF3_34 3830-3832   
   CHOFF3_35 3833-3835      CHOFF3_36 3836-3838      CHOFF3_37 3839-3841   
   CHOFF3_38 3842-3844      CHOFF3_39 3845-3847      CHOFF3_40 3848-3850   
   CHOFF3_41 3851-3853      CHOFF3_42 3854-3856      CHOFF3_43 3857-3859   
   CHOFF3_44 3860-3862      CHOFF3_45 3863-3865      CHOFF3_46 3866-3868   
   CHOFF3_47 3869-3871      CHOFF3_48 3872-3874      CHOFF3_49 3875-3877   
   CHOFF3_50 3878-3880      CHOFF3_51 3881-3883      CHOFF3_52 3884-3886   
   CHOFF3_53 3887-3889      CHOFF3_54 3890-3892      CHOFF3_55 3893-3895   
   CHOFF3_56 3896-3898      CHOFF3_57 3899-3901      CHOFF3_58 3902-3904   
   CHOFF3_59 3905-3907      CHOFF3_60 3908-3910      CHOFF3_61 3911-3913   
   CHOFF3_62 3914-3916      CHOFF3_63 3917-3919      CHOFF3_64 3920-3922   
   CHOFF3_65 3923-3925      CHOFF3_66 3926-3928      CHOFF3_67 3929-3931   
   CHOFF3_68 3932-3934      CHOFF3_69 3935-3937      CHOFF3_70 3938-3940   
   CHOFF3_71 3941-3943      CHOFF3_72 3944-3946      CHOFF3_73 3947-3949   
   CHOFF3_74 3950-3952      CHOFF3_75 3953-3955      CHOFF3_76 3956-3958   
   CHOFF3_77 3959-3961      CHOFF3_78 3962-3964      CHOFF3_79 3965-3967   
   CHOFF3_80 3968-3970      CHOFF3_81 3971-3973      CHOFF3_82 3974-3976   
   CHOFF3_83 3977-3979      CHOFF3_84 3980-3982      CHOFF3_85 3983-3985   
   CHOFF3_86 3986-3988      CHOFF3_87 3989-3991      CHOFF3_88 3992-3994   
   CHOFF3_89 3995-3997      CHOFF3_90 3998-4000      CHOFF3_91 4001-4003   
   CHOFF3_92 4004-4006      CHOFF3_93 4007-4009      CHOFF3_94 4010-4012   
   CHOFF3_95 4013-4015      CHOFF3_96 4016-4018      CHOFF3_97 4019-4021   
   CHOFF3_98 4022-4024      CHOFF3_99 4025-4027      CHOFF3_100 4028-4030  
   CHOFF3_101 4031-4033     CHOFF3_102 4034-4036     CHOFF3_103 4037-4039  
   CHOFF3_104 4040-4042     CHOFF3_105 4043-4045     CHOFF3_106 4046-4048  
   CHOFF3_107 4049-4051     CHOFF3_108 4052-4054     CHOFF3_109 4055-4057  
   CHOFF3_110 4058-4060     CHOFF3_111 4061-4063     CHOFF3_112 4064-4066  
   CHOFF3_113 4067-4069     CHOFF3_114 4070-4072     CHOFF3_115 4073-4075  
   CHOFF3_116 4076-4078     CHOFF3_117 4079-4081     CHOFF3_118 4082-4084  
   CHOFF3_119 4085-4087     CHOFF3_120 4088-4090     CHOFF4_1 4091-4093    
   CHOFF4_2 4094-4096       CHOFF4_3 4097-4099       CHOFF4_4 4100-4102    
   CHOFF4_5 4103-4105       CHOFF4_6 4106-4108       CHOFF4_7 4109-4111    
   CHOFF4_8 4112-4114       CHOFF4_9 4115-4117       CHOFF4_10 4118-4120   
   CHOFF4_11 4121-4123      CHOFF4_12 4124-4126      CHOFF4_13 4127-4129   
   CHOFF4_14 4130-4132      CHOFF4_15 4133-4135      CHOFF4_16 4136-4138   
   CHOFF4_17 4139-4141      CHOFF4_18 4142-4144      CHOFF4_19 4145-4147   
   CHOFF4_20 4148-4150      CHOFF4_21 4151-4153      CHOFF4_22 4154-4156   
   CHOFF4_23 4157-4159      CHOFF4_24 4160-4162      CHOFF4_25 4163-4165   
   CHOFF4_26 4166-4168      CHOFF4_27 4169-4171      CHOFF4_28 4172-4174   
   CHOFF4_29 4175-4177      CHOFF4_30 4178-4180      CHOFF4_31 4181-4183   
   CHOFF4_32 4184-4186      CHOFF4_33 4187-4189      CHOFF4_34 4190-4192   
   CHOFF4_35 4193-4195      CHOFF4_36 4196-4198      CHOFF4_37 4199-4201   
   CHOFF4_38 4202-4204      CHOFF4_39 4205-4207      CHOFF4_40 4208-4210   
   CHOFF4_41 4211-4213      CHOFF4_42 4214-4216      CHOFF4_43 4217-4219   
   CHOFF4_44 4220-4222      CHOFF4_45 4223-4225      CHOFF4_46 4226-4228   
   CHOFF4_47 4229-4231      CHOFF4_48 4232-4234      CHOFF4_49 4235-4237   
   CHOFF4_50 4238-4240      CHOFF4_51 4241-4243      CHOFF4_52 4244-4246   
   CHOFF4_53 4247-4249      CHOFF4_54 4250-4252      CHOFF4_55 4253-4255   
   CHOFF4_56 4256-4258      CHOFF4_57 4259-4261      CHOFF4_58 4262-4264   
   CHOFF4_59 4265-4267      CHOFF4_60 4268-4270      CHOFF4_61 4271-4273   
   CHOFF4_62 4274-4276      CHOFF4_63 4277-4279      CHOFF4_64 4280-4282   
   CHOFF4_65 4283-4285      CHOFF4_66 4286-4288      CHOFF4_67 4289-4291   
   CHOFF4_68 4292-4294      CHOFF4_69 4295-4297      CHOFF4_70 4298-4300   
   CHOFF4_71 4301-4303      CHOFF4_72 4304-4306      CHOFF4_73 4307-4309   
   CHOFF4_74 4310-4312      CHOFF4_75 4313-4315      CHOFF4_76 4316-4318   
   CHOFF4_77 4319-4321      CHOFF4_78 4322-4324      CHOFF4_79 4325-4327   
   CHOFF4_80 4328-4330      CHOFF4_81 4331-4333      CHOFF4_82 4334-4336   
   CHOFF4_83 4337-4339      CHOFF4_84 4340-4342      CHOFF4_85 4343-4345   
   CHOFF4_86 4346-4348      CHOFF4_87 4349-4351      CHOFF4_88 4352-4354   
   CHOFF4_89 4355-4357      CHOFF4_90 4358-4360      CHOFF4_91 4361-4363   
   CHOFF4_92 4364-4366      CHOFF4_93 4367-4369      CHOFF4_94 4370-4372   
   CHOFF4_95 4373-4375      CHOFF4_96 4376-4378      CHOFF4_97 4379-4381   
   CHOFF4_98 4382-4384      CHOFF4_99 4385-4387      CHOFF4_100 4388-4390  
   CHOFF4_101 4391-4393     CHOFF4_102 4394-4396     CHOFF4_103 4397-4399  
   CHOFF4_104 4400-4402     CHOFF4_105 4403-4405     CHOFF4_106 4406-4408  
   CHOFF4_107 4409-4411     CHOFF4_108 4412-4414     CHOFF4_109 4415-4417  
   CHOFF4_110 4418-4420     CHOFF4_111 4421-4423     CHOFF4_112 4424-4426  
   CHOFF4_113 4427-4429     CHOFF4_114 4430-4432     CHOFF4_115 4433-4435  
   CHOFF4_116 4436-4438     CHOFF4_117 4439-4441     CHOFF4_118 4442-4444  
   CHOFF4_119 4445-4447     CHOFF4_120 4448-4450     CHOFF5_1 4451-4453    
   CHOFF5_2 4454-4456       CHOFF5_3 4457-4459       CHOFF5_4 4460-4462    
   CHOFF5_5 4463-4465       CHOFF5_6 4466-4468       CHOFF5_7 4469-4471    
   CHOFF5_8 4472-4474       CHOFF5_9 4475-4477       CHOFF5_10 4478-4480   
   CHOFF5_11 4481-4483      CHOFF5_12 4484-4486      CHOFF5_13 4487-4489   
   CHOFF5_14 4490-4492      CHOFF5_15 4493-4495      CHOFF5_16 4496-4498   
   CHOFF5_17 4499-4501      CHOFF5_18 4502-4504      CHOFF5_19 4505-4507   
   CHOFF5_20 4508-4510      CHOFF5_21 4511-4513      CHOFF5_22 4514-4516   
   CHOFF5_23 4517-4519      CHOFF5_24 4520-4522      CHOFF5_25 4523-4525   
   CHOFF5_26 4526-4528      CHOFF5_27 4529-4531      CHOFF5_28 4532-4534   
   CHOFF5_29 4535-4537      CHOFF5_30 4538-4540      CHOFF5_31 4541-4543   
   CHOFF5_32 4544-4546      CHOFF5_33 4547-4549      CHOFF5_34 4550-4552   
   CHOFF5_35 4553-4555      CHOFF5_36 4556-4558      CHOFF5_37 4559-4561   
   CHOFF5_38 4562-4564      CHOFF5_39 4565-4567      CHOFF5_40 4568-4570   
   CHOFF5_41 4571-4573      CHOFF5_42 4574-4576      CHOFF5_43 4577-4579   
   CHOFF5_44 4580-4582      CHOFF5_45 4583-4585      CHOFF5_46 4586-4588   
   CHOFF5_47 4589-4591      CHOFF5_48 4592-4594      CHOFF5_49 4595-4597   
   CHOFF5_50 4598-4600      CHOFF5_51 4601-4603      CHOFF5_52 4604-4606   
   CHOFF5_53 4607-4609      CHOFF5_54 4610-4612      CHOFF5_55 4613-4615   
   CHOFF5_56 4616-4618      CHOFF5_57 4619-4621      CHOFF5_58 4622-4624   
   CHOFF5_59 4625-4627      CHOFF5_60 4628-4630      CHOFF5_61 4631-4633   
   CHOFF5_62 4634-4636      CHOFF5_63 4637-4639      CHOFF5_64 4640-4642   
   CHOFF5_65 4643-4645      CHOFF5_66 4646-4648      CHOFF5_67 4649-4651   
   CHOFF5_68 4652-4654      CHOFF5_69 4655-4657      CHOFF5_70 4658-4660   
   CHOFF5_71 4661-4663      CHOFF5_72 4664-4666      CHOFF5_73 4667-4669   
   CHOFF5_74 4670-4672      CHOFF5_75 4673-4675      CHOFF5_76 4676-4678   
   CHOFF5_77 4679-4681      CHOFF5_78 4682-4684      CHOFF5_79 4685-4687   
   CHOFF5_80 4688-4690      CHOFF5_81 4691-4693      CHOFF5_82 4694-4696   
   CHOFF5_83 4697-4699      CHOFF5_84 4700-4702      CHOFF5_85 4703-4705   
   CHOFF5_86 4706-4708      CHOFF5_87 4709-4711      CHOFF5_88 4712-4714   
   CHOFF5_89 4715-4717      CHOFF5_90 4718-4720      CHOFF5_91 4721-4723   
   CHOFF5_92 4724-4726      CHOFF5_93 4727-4729      CHOFF5_94 4730-4732   
   CHOFF5_95 4733-4735      CHOFF5_96 4736-4738      CHOFF5_97 4739-4741   
   CHOFF5_98 4742-4744      CHOFF5_99 4745-4747      CHOFF5_100 4748-4750  
   CHOFF5_101 4751-4753     CHOFF5_102 4754-4756     CHOFF5_103 4757-4759  
   CHOFF5_104 4760-4762     CHOFF5_105 4763-4765     CHOFF5_106 4766-4768  
   CHOFF5_107 4769-4771     CHOFF5_108 4772-4774     CHOFF5_109 4775-4777  
   CHOFF5_110 4778-4780     CHOFF5_111 4781-4783     CHOFF5_112 4784-4786  
   CHOFF5_113 4787-4789     CHOFF5_114 4790-4792     CHOFF5_115 4793-4795  
   CHOFF5_116 4796-4798     CHOFF5_117 4799-4801     CHOFF5_118 4802-4804  
   CHOFF5_119 4805-4807     CHOFF5_120 4808-4810     CHOFF6_1 4811-4813    
   CHOFF6_2 4814-4816       CHOFF6_3 4817-4819       CHOFF6_4 4820-4822    
   CHOFF6_5 4823-4825       CHOFF6_6 4826-4828       CHOFF6_7 4829-4831    
   CHOFF6_8 4832-4834       CHOFF6_9 4835-4837       CHOFF6_10 4838-4840   
   CHOFF6_11 4841-4843      CHOFF6_12 4844-4846      CHOFF6_13 4847-4849   
   CHOFF6_14 4850-4852      CHOFF6_15 4853-4855      CHOFF6_16 4856-4858   
   CHOFF6_17 4859-4861      CHOFF6_18 4862-4864      CHOFF6_19 4865-4867   
   CHOFF6_20 4868-4870      CHOFF6_21 4871-4873      CHOFF6_22 4874-4876   
   CHOFF6_23 4877-4879      CHOFF6_24 4880-4882      CHOFF6_25 4883-4885   
   CHOFF6_26 4886-4888      CHOFF6_27 4889-4891      CHOFF6_28 4892-4894   
   CHOFF6_29 4895-4897      CHOFF6_30 4898-4900      CHOFF6_31 4901-4903   
   CHOFF6_32 4904-4906      CHOFF6_33 4907-4909      CHOFF6_34 4910-4912   
   CHOFF6_35 4913-4915      CHOFF6_36 4916-4918      CHOFF6_37 4919-4921   
   CHOFF6_38 4922-4924      CHOFF6_39 4925-4927      CHOFF6_40 4928-4930   
   CHOFF6_41 4931-4933      CHOFF6_42 4934-4936      CHOFF6_43 4937-4939   
   CHOFF6_44 4940-4942      CHOFF6_45 4943-4945      CHOFF6_46 4946-4948   
   CHOFF6_47 4949-4951      CHOFF6_48 4952-4954      CHOFF6_49 4955-4957   
   CHOFF6_50 4958-4960      CHOFF6_51 4961-4963      CHOFF6_52 4964-4966   
   CHOFF6_53 4967-4969      CHOFF6_54 4970-4972      CHOFF6_55 4973-4975   
   CHOFF6_56 4976-4978      CHOFF6_57 4979-4981      CHOFF6_58 4982-4984   
   CHOFF6_59 4985-4987      CHOFF6_60 4988-4990      CHOFF6_61 4991-4993   
   CHOFF6_62 4994-4996      CHOFF6_63 4997-4999      CHOFF6_64 5000-5002   
   CHOFF6_65 5003-5005      CHOFF6_66 5006-5008      CHOFF6_67 5009-5011   
   CHOFF6_68 5012-5014      CHOFF6_69 5015-5017      CHOFF6_70 5018-5020   
   CHOFF6_71 5021-5023      CHOFF6_72 5024-5026      CHOFF6_73 5027-5029   
   CHOFF6_74 5030-5032      CHOFF6_75 5033-5035      CHOFF6_76 5036-5038   
   CHOFF6_77 5039-5041      CHOFF6_78 5042-5044      CHOFF6_79 5045-5047   
   CHOFF6_80 5048-5050      CHOFF6_81 5051-5053      CHOFF6_82 5054-5056   
   CHOFF6_83 5057-5059      CHOFF6_84 5060-5062      CHOFF6_85 5063-5065   
   CHOFF6_86 5066-5068      CHOFF6_87 5069-5071      CHOFF6_88 5072-5074   
   CHOFF6_89 5075-5077      CHOFF6_90 5078-5080      CHOFF6_91 5081-5083   
   CHOFF6_92 5084-5086      CHOFF6_93 5087-5089      CHOFF6_94 5090-5092   
   CHOFF6_95 5093-5095      CHOFF6_96 5096-5098      CHOFF6_97 5099-5101   
   CHOFF6_98 5102-5104      CHOFF6_99 5105-5107      CHOFF6_100 5108-5110  
   CHOFF6_101 5111-5113     CHOFF6_102 5114-5116     CHOFF6_103 5117-5119  
   CHOFF6_104 5120-5122     CHOFF6_105 5123-5125     CHOFF6_106 5126-5128  
   CHOFF6_107 5129-5131     CHOFF6_108 5132-5134     CHOFF6_109 5135-5137  
   CHOFF6_110 5138-5140     CHOFF6_111 5141-5143     CHOFF6_112 5144-5146  
   CHOFF6_113 5147-5149     CHOFF6_114 5150-5152     CHOFF6_115 5153-5155  
   CHOFF6_116 5156-5158     CHOFF6_117 5159-5161     CHOFF6_118 5162-5164  
   CHOFF6_119 5165-5167     CHOFF6_120 5168-5170     CHOFF7_1 5171-5173    
   CHOFF7_2 5174-5176       CHOFF7_3 5177-5179       CHOFF7_4 5180-5182    
   CHOFF7_5 5183-5185       CHOFF7_6 5186-5188       CHOFF7_7 5189-5191    
   CHOFF7_8 5192-5194       CHOFF7_9 5195-5197       CHOFF7_10 5198-5200   
   CHOFF7_11 5201-5203      CHOFF7_12 5204-5206      CHOFF7_13 5207-5209   
   CHOFF7_14 5210-5212      CHOFF7_15 5213-5215      CHOFF7_16 5216-5218   
   CHOFF7_17 5219-5221      CHOFF7_18 5222-5224      CHOFF7_19 5225-5227   
   CHOFF7_20 5228-5230      CHOFF7_21 5231-5233      CHOFF7_22 5234-5236   
   CHOFF7_23 5237-5239      CHOFF7_24 5240-5242      CHOFF7_25 5243-5245   
   CHOFF7_26 5246-5248      CHOFF7_27 5249-5251      CHOFF7_28 5252-5254   
   CHOFF7_29 5255-5257      CHOFF7_30 5258-5260      CHOFF7_31 5261-5263   
   CHOFF7_32 5264-5266      CHOFF7_33 5267-5269      CHOFF7_34 5270-5272   
   CHOFF7_35 5273-5275      CHOFF7_36 5276-5278      CHOFF7_37 5279-5281   
   CHOFF7_38 5282-5284      CHOFF7_39 5285-5287      CHOFF7_40 5288-5290   
   CHOFF7_41 5291-5293      CHOFF7_42 5294-5296      CHOFF7_43 5297-5299   
   CHOFF7_44 5300-5302      CHOFF7_45 5303-5305      CHOFF7_46 5306-5308   
   CHOFF7_47 5309-5311      CHOFF7_48 5312-5314      CHOFF7_49 5315-5317   
   CHOFF7_50 5318-5320      CHOFF7_51 5321-5323      CHOFF7_52 5324-5326   
   CHOFF7_53 5327-5329      CHOFF7_54 5330-5332      CHOFF7_55 5333-5335   
   CHOFF7_56 5336-5338      CHOFF7_57 5339-5341      CHOFF7_58 5342-5344   
   CHOFF7_59 5345-5347      CHOFF7_60 5348-5350      CHOFF7_61 5351-5353   
   CHOFF7_62 5354-5356      CHOFF7_63 5357-5359      CHOFF7_64 5360-5362   
   CHOFF7_65 5363-5365      CHOFF7_66 5366-5368      CHOFF7_67 5369-5371   
   CHOFF7_68 5372-5374      CHOFF7_69 5375-5377      CHOFF7_70 5378-5380   
   CHOFF7_71 5381-5383      CHOFF7_72 5384-5386      CHOFF7_73 5387-5389   
   CHOFF7_74 5390-5392      CHOFF7_75 5393-5395      CHOFF7_76 5396-5398   
   CHOFF7_77 5399-5401      CHOFF7_78 5402-5404      CHOFF7_79 5405-5407   
   CHOFF7_80 5408-5410      CHOFF7_81 5411-5413      CHOFF7_82 5414-5416   
   CHOFF7_83 5417-5419      CHOFF7_84 5420-5422      CHOFF7_85 5423-5425   
   CHOFF7_86 5426-5428      CHOFF7_87 5429-5431      CHOFF7_88 5432-5434   
   CHOFF7_89 5435-5437      CHOFF7_90 5438-5440      CHOFF7_91 5441-5443   
   CHOFF7_92 5444-5446      CHOFF7_93 5447-5449      CHOFF7_94 5450-5452   
   CHOFF7_95 5453-5455      CHOFF7_96 5456-5458      CHOFF7_97 5459-5461   
   CHOFF7_98 5462-5464      CHOFF7_99 5465-5467      CHOFF7_100 5468-5470  
   CHOFF7_101 5471-5473     CHOFF7_102 5474-5476     CHOFF7_103 5477-5479  
   CHOFF7_104 5480-5482     CHOFF7_105 5483-5485     CHOFF7_106 5486-5488  
   CHOFF7_107 5489-5491     CHOFF7_108 5492-5494     CHOFF7_109 5495-5497  
   CHOFF7_110 5498-5500     CHOFF7_111 5501-5503     CHOFF7_112 5504-5506  
   CHOFF7_113 5507-5509     CHOFF7_114 5510-5512     CHOFF7_115 5513-5515  
   CHOFF7_116 5516-5518     CHOFF7_117 5519-5521     CHOFF7_118 5522-5524  
   CHOFF7_119 5525-5527     CHOFF7_120 5528-5530     CHOFF8_1 5531-5533    
   CHOFF8_2 5534-5536       CHOFF8_3 5537-5539       CHOFF8_4 5540-5542    
   CHOFF8_5 5543-5545       CHOFF8_6 5546-5548       CHOFF8_7 5549-5551    
   CHOFF8_8 5552-5554       CHOFF8_9 5555-5557       CHOFF8_10 5558-5560   
   CHOFF8_11 5561-5563      CHOFF8_12 5564-5566      CHOFF8_13 5567-5569   
   CHOFF8_14 5570-5572      CHOFF8_15 5573-5575      CHOFF8_16 5576-5578   
   CHOFF8_17 5579-5581      CHOFF8_18 5582-5584      CHOFF8_19 5585-5587   
   CHOFF8_20 5588-5590      CHOFF8_21 5591-5593      CHOFF8_22 5594-5596   
   CHOFF8_23 5597-5599      CHOFF8_24 5600-5602      CHOFF8_25 5603-5605   
   CHOFF8_26 5606-5608      CHOFF8_27 5609-5611      CHOFF8_28 5612-5614   
   CHOFF8_29 5615-5617      CHOFF8_30 5618-5620      CHOFF8_31 5621-5623   
   CHOFF8_32 5624-5626      CHOFF8_33 5627-5629      CHOFF8_34 5630-5632   
   CHOFF8_35 5633-5635      CHOFF8_36 5636-5638      CHOFF8_37 5639-5641   
   CHOFF8_38 5642-5644      CHOFF8_39 5645-5647      CHOFF8_40 5648-5650   
   CHOFF8_41 5651-5653      CHOFF8_42 5654-5656      CHOFF8_43 5657-5659   
   CHOFF8_44 5660-5662      CHOFF8_45 5663-5665      CHOFF8_46 5666-5668   
   CHOFF8_47 5669-5671      CHOFF8_48 5672-5674      CHOFF8_49 5675-5677   
   CHOFF8_50 5678-5680      CHOFF8_51 5681-5683      CHOFF8_52 5684-5686   
   CHOFF8_53 5687-5689      CHOFF8_54 5690-5692      CHOFF8_55 5693-5695   
   CHOFF8_56 5696-5698      CHOFF8_57 5699-5701      CHOFF8_58 5702-5704   
   CHOFF8_59 5705-5707      CHOFF8_60 5708-5710      CHOFF8_61 5711-5713   
   CHOFF8_62 5714-5716      CHOFF8_63 5717-5719      CHOFF8_64 5720-5722   
   CHOFF8_65 5723-5725      CHOFF8_66 5726-5728      CHOFF8_67 5729-5731   
   CHOFF8_68 5732-5734      CHOFF8_69 5735-5737      CHOFF8_70 5738-5740   
   CHOFF8_71 5741-5743      CHOFF8_72 5744-5746      CHOFF8_73 5747-5749   
   CHOFF8_74 5750-5752      CHOFF8_75 5753-5755      CHOFF8_76 5756-5758   
   CHOFF8_77 5759-5761      CHOFF8_78 5762-5764      CHOFF8_79 5765-5767   
   CHOFF8_80 5768-5770      CHOFF8_81 5771-5773      CHOFF8_82 5774-5776   
   CHOFF8_83 5777-5779      CHOFF8_84 5780-5782      CHOFF8_85 5783-5785   
   CHOFF8_86 5786-5788      CHOFF8_87 5789-5791      CHOFF8_88 5792-5794   
   CHOFF8_89 5795-5797      CHOFF8_90 5798-5800      CHOFF8_91 5801-5803   
   CHOFF8_92 5804-5806      CHOFF8_93 5807-5809      CHOFF8_94 5810-5812   
   CHOFF8_95 5813-5815      CHOFF8_96 5816-5818      CHOFF8_97 5819-5821   
   CHOFF8_98 5822-5824      CHOFF8_99 5825-5827      CHOFF8_100 5828-5830  
   CHOFF8_101 5831-5833     CHOFF8_102 5834-5836     CHOFF8_103 5837-5839  
   CHOFF8_104 5840-5842     CHOFF8_105 5843-5845     CHOFF8_106 5846-5848  
   CHOFF8_107 5849-5851     CHOFF8_108 5852-5854     CHOFF8_109 5855-5857  
   CHOFF8_110 5858-5860     CHOFF8_111 5861-5863     CHOFF8_112 5864-5866  
   CHOFF8_113 5867-5869     CHOFF8_114 5870-5872     CHOFF8_115 5873-5875  
   CHOFF8_116 5876-5878     CHOFF8_117 5879-5881     CHOFF8_118 5882-5884  
   CHOFF8_119 5885-5887     CHOFF8_120 5888-5890     CHFED1 5891-5893      
   CHFED2 5894-5896         CHFED3 5897-5899         CHFED4 5900-5902      
   CHFED5 5903-5905         CHFED6 5906-5908         CHFED7 5909-5911      
   CHFED8 5912-5914         CHFED9 5915-5917         CHFED10 5918-5920     
   CHFED11 5921-5923        CHFED12 5924-5926        CHFED13 5927-5929     
   CHFED14 5930-5932        CHFED15 5933-5935        CHFED16 5936-5938     
   CHFED17 5939-5941        CHFED18 5942-5944        CHFED19 5945-5947     
   CHFED20 5948-5950        CHFED21 5951-5953        CHFED22 5954-5956     
   CHFED23 5957-5959        CHFED24 5960-5962        CHFED25 5963-5965     
   CHFED26 5966-5968        CHFED27 5969-5971        CHFED28 5972-5974     
   CHFED29 5975-5977        CHFED30 5978-5980        CHFED31 5981-5983     
   CHFED32 5984-5986        CHFED33 5987-5989        CHFED34 5990-5992     
   CHFED35 5993-5995        CHFED36 5996-5998        CHFED37 5999-6001     
   CHFED38 6002-6004        CHFED39 6005-6007        CHFED40 6008-6010     
   CHFED41 6011-6013        CHFED42 6014-6016        CHFED43 6017-6019     
   CHFED44 6020-6022        CHFED45 6023-6025        CHFED46 6026-6028     
   CHFED47 6029-6031        CHFED48 6032-6034        CHFED49 6035-6037     
   CHFED50 6038-6040        CHFED51 6041-6043        CHFED52 6044-6046     
   CHFED53 6047-6049        CHFED54 6050-6052        CHFED55 6053-6055     
   CHFED56 6056-6058        CHFED57 6059-6061        CHFED58 6062-6064     
   CHFED59 6065-6067        CHFED60 6068-6070        CHFED61 6071-6073     
   CHFED62 6074-6076        CHFED63 6077-6079        CHFED64 6080-6082     
   CHFED65 6083-6085        CHFED66 6086-6088        CHFED67 6089-6091     
   CHFED68 6092-6094        CHFED69 6095-6097        CHFED70 6098-6100     
   CHFED71 6101-6103        CHFED72 6104-6106        CHFED73 6107-6109     
   CHFED74 6110-6112        CHFED75 6113-6115        CHFED76 6116-6118     
   CHFED77 6119-6121        CHFED78 6122-6124        CHFED79 6125-6127     
   CHFED80 6128-6130        CHFED81 6131-6133        CHFED82 6134-6136     
   CHFED83 6137-6139        CHFED84 6140-6142        CHFED85 6143-6145     
   CHFED86 6146-6148        CHFED87 6149-6151        CHFED88 6152-6154     
   CHFED89 6155-6157        CHFED90 6158-6160        CHFED91 6161-6163     
   CHFED92 6164-6166        CHFED93 6167-6169        CHFED94 6170-6172     
   CHFED95 6173-6175        CHFED96 6176-6178        CHFED97 6179-6181     
   CHFED98 6182-6184        CHFED99 6185-6187        CHFED100 6188-6190    
   CHFED101 6191-6193       CHFED102 6194-6196       CHFED103 6197-6199    
   CHFED104 6200-6202       CHFED105 6203-6205       CHFED106 6206-6208    
   CHFED107 6209-6211       CHFED108 6212-6214       CHFED109 6215-6217    
   CHFED110 6218-6220       CHFED111 6221-6223       CHFED112 6224-6226    
   CHFED113 6227-6229       CHFED114 6230-6232       CHFED115 6233-6235    
   CHFED116 6236-6238       CHFED117 6239-6241       CHFED118 6242-6244    
   CHFED119 6245-6247       CHFED120 6248-6250       CHTRIB1 6251-6253     
   CHTRIB2 6254-6256        CHTRIB3 6257-6259        CHTRIB4 6260-6262     
   CHTRIB5 6263-6265        CHTRIB6 6266-6268        CHTRIB7 6269-6271     
   CHTRIB8 6272-6274        CHTRIB9 6275-6277        CHTRIB10 6278-6280    
   CHTRIB11 6281-6283       CHTRIB12 6284-6286       CHTRIB13 6287-6289    
   CHTRIB14 6290-6292       CHTRIB15 6293-6295       CHTRIB16 6296-6298    
   CHTRIB17 6299-6301       CHTRIB18 6302-6304       CHTRIB19 6305-6307    
   CHTRIB20 6308-6310       CHTRIB21 6311-6313       CHTRIB22 6314-6316    
   CHTRIB23 6317-6319       CHTRIB24 6320-6322       CHTRIB25 6323-6325    
   CHTRIB26 6326-6328       CHTRIB27 6329-6331       CHTRIB28 6332-6334    
   CHTRIB29 6335-6337       CHTRIB30 6338-6340       CHTRIB31 6341-6343    
   CHTRIB32 6344-6346       CHTRIB33 6347-6349       CHTRIB34 6350-6352    
   CHTRIB35 6353-6355       CHTRIB36 6356-6358       CHTRIB37 6359-6361    
   CHTRIB38 6362-6364       CHTRIB39 6365-6367       CHTRIB40 6368-6370    
   CHTRIB41 6371-6373       CHTRIB42 6374-6376       CHTRIB43 6377-6379    
   CHTRIB44 6380-6382       CHTRIB45 6383-6385       CHTRIB46 6386-6388    
   CHTRIB47 6389-6391       CHTRIB48 6392-6394       CHTRIB49 6395-6397    
   CHTRIB50 6398-6400       CHTRIB51 6401-6403       CHTRIB52 6404-6406    
   CHTRIB53 6407-6409       CHTRIB54 6410-6412       CHTRIB55 6413-6415    
   CHTRIB56 6416-6418       CHTRIB57 6419-6421       CHTRIB58 6422-6424    
   CHTRIB59 6425-6427       CHTRIB60 6428-6430       CHTRIB61 6431-6433    
   CHTRIB62 6434-6436       CHTRIB63 6437-6439       CHTRIB64 6440-6442    
   CHTRIB65 6443-6445       CHTRIB66 6446-6448       CHTRIB67 6449-6451    
   CHTRIB68 6452-6454       CHTRIB69 6455-6457       CHTRIB70 6458-6460    
   CHTRIB71 6461-6463       CHTRIB72 6464-6466       CHTRIB73 6467-6469    
   CHTRIB74 6470-6472       CHTRIB75 6473-6475       CHTRIB76 6476-6478    
   CHTRIB77 6479-6481       CHTRIB78 6482-6484       CHTRIB79 6485-6487    
   CHTRIB80 6488-6490       CHTRIB81 6491-6493       CHTRIB82 6494-6496    
   CHTRIB83 6497-6499       CHTRIB84 6500-6502       CHTRIB85 6503-6505    
   CHTRIB86 6506-6508       CHTRIB87 6509-6511       CHTRIB88 6512-6514    
   CHTRIB89 6515-6517       CHTRIB90 6518-6520       CHTRIB91 6521-6523    
   CHTRIB92 6524-6526       CHTRIB93 6527-6529       CHTRIB94 6530-6532    
   CHTRIB95 6533-6535       CHTRIB96 6536-6538       CHTRIB97 6539-6541    
   CHTRIB98 6542-6544       CHTRIB99 6545-6547       CHTRIB100 6548-6550   
   CHTRIB101 6551-6553      CHTRIB102 6554-6556      CHTRIB103 6557-6559   
   CHTRIB104 6560-6562      CHTRIB105 6563-6565      CHTRIB106 6566-6568   
   CHTRIB107 6569-6571      CHTRIB108 6572-6574      CHTRIB109 6575-6577   
   CHTRIB110 6578-6580      CHTRIB111 6581-6583      CHTRIB112 6584-6586   
   CHTRIB113 6587-6589      CHTRIB114 6590-6592      CHTRIB115 6593-6595   
   CHTRIB116 6596-6598      CHTRIB117 6599-6601      CHTRIB118 6602-6604   
   CHTRIB119 6605-6607      CHTRIB120 6608-6610      CHAGE1 6611-6613      
   CHAGE2 6614-6616         CHAGE3 6617-6619         CHAGE4 6620-6622      
   CHAGE5 6623-6625         CHAGE6 6626-6628         CHAGE7 6629-6631      
   CHAGE8 6632-6634         CHAGE9 6635-6637         CHAGE10 6638-6640     
   CHAGE11 6641-6643        CHAGE12 6644-6646        CHAGE13 6647-6649     
   CHAGE14 6650-6652        CHAGE15 6653-6655        CHAGE16 6656-6658     
   CHAGE17 6659-6661        CHAGE18 6662-6664        CHAGE19 6665-6667     
   CHAGE20 6668-6670        CHAGE21 6671-6673        CHAGE22 6674-6676     
   CHAGE23 6677-6679        CHAGE24 6680-6682        CHAGE25 6683-6685     
   CHAGE26 6686-6688        CHAGE27 6689-6691        CHAGE28 6692-6694     
   CHAGE29 6695-6697        CHAGE30 6698-6700        CHAGE31 6701-6703     
   CHAGE32 6704-6706        CHAGE33 6707-6709        CHAGE34 6710-6712     
   CHAGE35 6713-6715        CHAGE36 6716-6718        CHAGE37 6719-6721     
   CHAGE38 6722-6724        CHAGE39 6725-6727        CHAGE40 6728-6730     
   CHAGE41 6731-6733        CHAGE42 6734-6736        CHAGE43 6737-6739     
   CHAGE44 6740-6742        CHAGE45 6743-6745        CHAGE46 6746-6748     
   CHAGE47 6749-6751        CHAGE48 6752-6754        CHAGE49 6755-6757     
   CHAGE50 6758-6760        CHAGE51 6761-6763        CHAGE52 6764-6766     
   CHAGE53 6767-6769        CHAGE54 6770-6772        CHAGE55 6773-6775     
   CHAGE56 6776-6778        CHAGE57 6779-6781        CHAGE58 6782-6784     
   CHAGE59 6785-6787        CHAGE60 6788-6790        CHAGE61 6791-6793     
   CHAGE62 6794-6796        CHAGE63 6797-6799        CHAGE64 6800-6802     
   CHAGE65 6803-6805        CHAGE66 6806-6808        CHAGE67 6809-6811     
   CHAGE68 6812-6814        CHAGE69 6815-6817        CHAGE70 6818-6820     
   CHAGE71 6821-6823        CHAGE72 6824-6826        CHAGE73 6827-6829     
   CHAGE74 6830-6832        CHAGE75 6833-6835        CHAGE76 6836-6838     
   CHAGE77 6839-6841        CHAGE78 6842-6844        CHAGE79 6845-6847     
   CHAGE80 6848-6850        CHAGE81 6851-6853        CHAGE82 6854-6856     
   CHAGE83 6857-6859        CHAGE84 6860-6862        CHAGE85 6863-6865     
   CHAGE86 6866-6868        CHAGE87 6869-6871        CHAGE88 6872-6874     
   CHAGE89 6875-6877        CHAGE90 6878-6880        CHAGE91 6881-6883     
   CHAGE92 6884-6886        CHAGE93 6887-6889        CHAGE94 6890-6892     
   CHAGE95 6893-6895        CHAGE96 6896-6898        CHAGE97 6899-6901     
   CHAGE98 6902-6904        CHAGE99 6905-6907        CHAGE100 6908-6910    
   CHAGE101 6911-6913       CHAGE102 6914-6916       CHAGE103 6917-6919    
   CHAGE104 6920-6922       CHAGE105 6923-6925       CHAGE106 6926-6928    
   CHAGE107 6929-6931       CHAGE108 6932-6934       CHAGE109 6935-6937    
   CHAGE110 6938-6940       CHAGE111 6941-6943       CHAGE112 6944-6946    
   CHAGE113 6947-6949       CHAGE114 6950-6952       CHAGE115 6953-6955    
   CHAGE116 6956-6958       CHAGE117 6959-6961       CHAGE118 6962-6964    
   CHAGE119 6965-6967       CHAGE120 6968-6970       CHGDL1 6971-7030 (A)  
   CHGDL2 7031-7080 (A)     CHGDL3 7081-7133 (A)     CHGDL4 7134-7184 (A)  
   CHGDL5 7185-7244 (A)     CHGDL6 7245-7294 (A)     CHGDL7 7295-7342 (A)  
   CHGDL8 7343-7393 (A)     CHGDL9 7394-7443 (A)     CHGDL10 7444-7493 (A) 
   CHGDL11 7494-7593 (A)    CHGDL12 7594-7643 (A)    CHGDL13 7644-7695 (A) 
   CHGDL14 7696-7745 (A)    CHGDL15 7746-7784 (A)    CHGDL16 7785-7823 (A) 
   CHGDL17 7824-7873 (A)    CHGDL18 7874-7923 (A)    CHGDL19 7924-7973 (A) 
   CHGDL20 7974-8012 (A)    CHGDL21 8013-8062 (A)    CHGDL22 8063-8107 (A) 
   CHGDL23 8108-8157 (A)    CHGDL24 8158-8221 (A)    CHGDL25 8222-8260 (A) 
   CHGDL26 8261-8297 (A)    CHGDL27 8298-8333 (A)    CHGDL28 8334-8370 (A) 
   CHGDL29 8371-8402 (A)    CHGDL30 8403-8438 (A)    CHGDL31 8439-8474 (A) 
   CHGDL32 8475-8511 (A)    CHGDL33 8512-8550 (A)    CHGDL34 8551-8594 (A) 
   CHGDL35 8595-8630 (A)    CHGDL36 8631-8666 (A)    CHGDL37 8667-8700 (A) 
   CHGDL38 8701-8725 (A)    CHGDL39 8726-8750 (A)    CHGDL40 8751-8775 (A) 
   CHGDL41 8776-8797 (A)    CHGDL42 8798-8833 (A)    CHGDL43 8834-8855 (A) 
   CHGDL44 8856-8888 (A)    CHGDL45 8889-8909 (A)    CHGDL46 8910-8943 (A) 
   CHGDL47 8944-8979 (A)    CHGDL48 8980-9001 (A)    CHGDL49 9002-9022 (A) 
   CHGDL50 9023-9047 (A)    CHGDL51 9048-9058 (A)    CHGDL52 9059-9082 (A) 
   CHGDL53 9083-9103 (A)    CHGDL54 9104-9137 (A)    CHGDL55 9138-9161 (A) 
   CHGDL56 9162-9172 (A)    CHGDL57 9173-9183 (A)    CHGDL58 9184-9194 (A) 
   CHGDL59 9195-9205 (A)    CHGDL60 9206-9226 (A)    CHGDL61 9227-9237 (A) 
   CHGDL62 9238-9248 (A)    CHGDL63 9249-9259 (A)    CHGDL64 9260-9270 (A) 
   CHGDL65 9271-9281 (A)    CHGDL66 9282-9292 (A)    CHGDL67 9293-9303 (A) 
   CHGDL68 9304-9314 (A)    CHGDL69 9315-9325 (A)    CHGDL70 9326-9336 (A) 
   CHGDL71 9337-9347 (A)    CHGDL72 9348-9358 (A)    CHGDL73 9359-9369 (A) 
   CHGDL74 9370-9380 (A)    CHGDL75 9381-9391 (A)    CHGDL76 9392-9402 (A) 
   CHGDL77 9403-9413 (A)    CHGDL78 9414-9424 (A)    CHGDL79 9425-9435 (A) 
   CHGDL80 9436-9446 (A)    CHGDL81 9447-9457 (A)    CHGDL82 9458-9468 (A) 
   CHGDL83 9469-9479 (A)    CHGDL84 9480-9490 (A)    CHGDL85 9491-9501 (A) 
   CHGDL86 9502-9512 (A)    CHGDL87 9513-9523 (A)    CHGDL88 9524-9534 (A) 
   CHGDL89 9535-9545 (A)    CHGDL90 9546-9556 (A)    CHGDL91 9557-9567 (A) 
   CHGDL92 9568-9578 (A)    CHGDL93 9579-9589 (A)    CHGDL94 9590-9600 (A) 
   CHGDL95 9601-9611 (A)    CHGDL96 9612-9622 (A)    CHGDL97 9623-9633 (A) 
   CHGDL98 9634-9644 (A)    CHGDL99 9645-9655 (A)    CHGDL100 9656-9666 (A)
   CHGDL101 9667-9677 (A)   CHGDL102 9678-9688 (A)   CHGDL103 9689-9699 (A)
   CHGDL104 9700-9710 (A)   CHGDL105 9711-9721 (A)   CHGDL106 9722-9732 (A)
   CHGDL107 9733-9743 (A)   CHGDL108 9744-9754 (A)   CHGDL109 9755-9765 (A)
   CHGDL110 9766-9776 (A)   CHGDL111 9777-9787 (A)   CHGDL112 9788-9798 (A)
   CHGDL113 9799-9809 (A)   CHGDL114 9810-9820 (A)   CHGDL115 9821-9828 (A)
   CHGDL116 9829-9839 (A)   CHGDL117 9840-9850 (A)   CHGDL118 9851-9858 (A)
   CHGDL119 9859-9866 (A)   CHGDL120 9867-9874 (A)   CHSTATE1 9875-9876 (A)
   CHSTATE2 9877-9878 (A)   CHSTATE3 9879-9880 (A)   CHSTATE4 9881-9882 (A)
   CHSTATE5 9883-9884 (A)   CHSTATE6 9885-9886 (A)   CHSTATE7 9887-9888 (A)
   CHSTATE8 9889-9890 (A)   CHSTATE9 9891-9892 (A)   CHSTATE10 9893-9894 (A)
   CHSTATE11 9895-9896 (A)   CHSTATE12 9897-9898 (A)   CHSTATE13 9899-9900 (A)
   CHSTATE14 9901-9902 (A)   CHSTATE15 9903-9904 (A)   CHSTATE16 9905-9906 (A)
   CHSTATE17 9907-9908 (A)   CHSTATE18 9909-9910 (A)   CHSTATE19 9911-9912 (A)
   CHSTATE20 9913-9914 (A)   CHSTATE21 9915-9916 (A)   CHSTATE22 9917-9918 (A)
   CHSTATE23 9919-9920 (A)   CHSTATE24 9921-9922 (A)   CHSTATE25 9923-9924 (A)
   CHSTATE26 9925-9926 (A)   CHSTATE27 9927-9928 (A)   CHSTATE28 9929-9930 (A)
   CHSTATE29 9931-9932 (A)   CHSTATE30 9933-9934 (A)   CHSTATE31 9935-9936 (A)
   CHSTATE32 9937-9938 (A)   CHSTATE33 9939-9940 (A)   CHSTATE34 9941-9942 (A)
   CHSTATE35 9943-9944 (A)   CHSTATE36 9945-9946 (A)   CHSTATE37 9947-9948 (A)
   CHSTATE38 9949-9950 (A)   CHSTATE39 9951-9952 (A)   CHSTATE40 9953-9954 (A)
   CHSTATE41 9955-9956 (A)   CHSTATE42 9957-9958 (A)   CHSTATE43 9959-9960 (A)
   CHSTATE44 9961-9962 (A)   CHSTATE45 9963-9964 (A)   CHSTATE46 9965-9966 (A)
   CHSTATE47 9967-9968 (A)   CHSTATE48 9969-9970 (A)   CHSTATE49 9971-9972 (A)
   CHSTATE50 9973-9974 (A)   CHSTATE51 9975-9976 (A)   CHSTATE52 9977-9978 (A)
   CHSTATE53 9979-9980 (A)   CHSTATE54 9981-9982 (A)   CHSTATE55 9983-9984 (A)
   CHSTATE56 9985-9986 (A)   CHSTATE57 9987-9988 (A)   CHSTATE58 9989-9990 (A)
   CHSTATE59 9991-9992 (A)   CHSTATE60 9993-9994 (A)   CHSTATE61 9995-9996 (A)
   CHSTATE62 9997-9998 (A)   CHSTATE63 9999-10000 (A)
   CHSTATE64 10001-10002 (A)   CHSTATE65 10003-10004 (A)
   CHSTATE66 10005-10006 (A)   CHSTATE67 10007-10008 (A)
   CHSTATE68 10009-10010 (A)   CHSTATE69 10011-10012 (A)
   CHSTATE70 10013-10014 (A)   CHSTATE71 10015-10016 (A)
   CHSTATE72 10017-10018 (A)   CHSTATE73 10019-10020 (A)
   CHSTATE74 10021-10022 (A)   CHSTATE75 10023-10024 (A)
   CHSTATE76 10025-10026 (A)   CHSTATE77 10027-10028 (A)
   CHSTATE78 10029-10030 (A)   CHSTATE79 10031-10032 (A)
   CHSTATE80 10033-10034 (A)   CHSTATE81 10035-10036 (A)
   CHSTATE82 10037-10038 (A)   CHSTATE83 10039-10040 (A)
   CHSTATE84 10041-10042 (A)   CHSTATE85 10043-10044 (A)
   CHSTATE86 10045-10046 (A)   CHSTATE87 10047-10048 (A)
   CHSTATE88 10049-10050 (A)   CHSTATE89 10051-10052 (A)
   CHSTATE90 10053-10054 (A)   CHSTATE91 10055-10056 (A)
   CHSTATE92 10057-10058 (A)   CHSTATE93 10059-10060 (A)
   CHSTATE94 10061-10062 (A)   CHSTATE95 10063-10064 (A)
   CHSTATE96 10065-10066 (A)   CHSTATE97 10067-10068 (A)
   CHSTATE98 10069-10070 (A)   CHSTATE99 10071-10072 (A)
   CHSTATE100 10073-10074 (A)   CHSTATE101 10075-10076 (A)
   CHSTATE102 10077-10078 (A)   CHSTATE103 10079-10080 (A)
   CHSTATE104 10081-10082 (A)   CHSTATE105 10083-10084 (A)
   CHSTATE106 10085-10086 (A)   CHSTATE107 10087-10088 (A)
   CHSTATE108 10089-10090 (A)   CHSTATE109 10091-10092 (A)
   CHSTATE110 10093-10094 (A)   CHSTATE111 10095-10096 (A)
   CHSTATE112 10097-10098 (A)   CHSTATE113 10099-10100 (A)
   CHSTATE114 10101-10102 (A)   CHSTATE115 10103-10104 (A)
   CHSTATE116 10105-10106 (A)   CHSTATE117 10107-10108 (A)
   CHSTATE118 10109-10110 (A)   CHSTATE119 10111-10112 (A)
   CHSTATE120 10113-10114 (A) .

VARIABLE LABELS
   USSCIDN 'USSCIDN'
.

SAVE OUTFILE='.\crimhist17nid.sav'.
