* Encoding: UTF-8.
/*********************************************************************************************************/
/*                                                                                                                                 */
/* This SPSS program will extract the United States Sentencing Commission's fiscal year  */
/* 2021 Organizational file and create a SPSS dataset.                                                     */
/*                                                                                                                                 */
/* Prior to running the program you must update the DAT file location in the                       */
/* FILE HANDLE DATA / NAME line to correspond to the location of the file on your           */
/* computer, replacing the '.' with the folder path location (e.g. 'C:\temp').                            */
/*                                                                                                                                 */
/* You must also update the file output location in the SAVE OUTFILE statement at the     */
/* end of the program to correspond to the folder you want the output file to be located,      */
/* replacing the '.' with the folder path location (e.g. 'C:\temp') .                                          */
/*                                                                                                                                 */
/*********************************************************************************************************/

FILE HANDLE DATA / NAME=".\corp21nid.dat" ENCODING="CP1252" / LRECL=4245 .

DATA LIST FILE=DATA/
   ACCEPT 1-3               BUSCLAS 4-7              CANTPAY 8-10          
   CCULPSCO 11-13           CH2APP 14-16             CH8FINGD 17-19        
   CMSRVORD 20-22           COFI 23-25               COMPLY 26-28          
   COMPLYPR 29-31           CRIMPURP 32-34           DETBFINE 35-37        
   DISPOSIT 38-40           EMPLOYNM 41-43           FCULPSCO 44-46        
   FRAUDTYP 47-49           FINSTDS 50-52            HISTORY 53-55         
   HSMISCND 56-58           INCORLOC 59-61           INCORPYR 62-65        
   INDICT 66-68             INPLEA1 69-71            INPLEA2 72-74         
   INPLEA3 75-77            INPLEA4 78-80            INPLEA5 81-83         
   INPLEA6 84-86            INPLEA7 87-89            INPLEA8 90-92         
   INPLEA9 93-95            INPLEA10 96-98           INPLEA11 99-101       
   INPLEA12 102-104         INNOPL1 105-107          INNOPL2 108-110       
   INNOPL3 111-113          INNOPL4 114-116          INNOPL5 117-119       
   INNOPL6 120-122          INNOPL7 123-125          INNOPL8 126-128       
   INNOPL9 129-131          INNOPL10 132-134         INNOPL11 135-137      
   INNOPL12 138-140         JANDC 141-143            NEWCNVTN 144-146      
   NOCOMP 147-149           NOCOUNTS 150-152         NOREAVAR 153-155      
   NOUSTAT 156-158          OBSTRUCT 159-161         OFFLVL 162-164        
   ORDERCE 165-167          ORGTYPE 168-170          OWNSTRCT 171-173      
   PLEA 174-176             PRIMOFF 177-179          PRCIVIL 180-182       
   PRCRIME 183-185          PROBATN 186-188          PROBMON 189-191       
   PSR 192-194              QUARTER 195-197          REAS1 198-200         
   REAS2 201-203            REAS3 204-206            REAS4 207-209         
   REAS5 210-212            REAS6 213-215            REASON3 216-218       
   REASON4 219-221          REASONS 222-224          REMEDORD 225-227      
   SELFREP 228-230          SENTRNGE 231-233         SOURCES 234-236       
   TOLERNCE 237-239         TYPEOTHS 240-242         VICTNOTE 243-245      
   VIOLATE 246-248          AMENDYR 249-252          SENTYR 253-256        
   BASEFINE 257-265         COSTASSM 266-273         DISGORGE 274-281      
   FINOFFST 282-289         FORFEITR 290-298         GLFINMAX 299-307      
   GLFINMIN 308-316         STATMIN 317-324          STATMAX 325-332       
   RESTCAT 333-340          FINECAT 341-348          SUSFNCAT 349-356      
   LCAT1 357-364            LCAT2 365-372            LCATHI 373-380        
   LCATS1 381-388           LCATS2 389-396           LCATSHI 397-404       
   LCATR1 405-412           LCATR2 413-420           LCATRHI 421-428       
   LCATC1 429-436           LCATC2 437-444           LCATCHI 445-452       
   LCATU1 453-460           LCATU2 461-468           LCATUHI 469-476       
   CPIDN 477-483            BUSTEXT 484 (A)          FINSTXT 485 (A)       
   OWNSTEXT 486 (A)         PRMONTXT 487-585 (A)     ORDERTXT 586-747 (A)  
   TYPEOTTX 748-936 (A)     MINFINML 937-944         MAXFINML 945-952      
   ADJOFL1 953-955          ADJOFL2 956-958          ADJOFLHI 959-961      
   ADJ_B1 962-964           ADJ_B2 965-967           ADJ_BHI 968-970       
   ADJ_C1 971-973           ADJ_C2 974-976           ADJ_CHI 977-979       
   ADJ_D1 980-982           ADJ_D2 983-985           ADJ_DHI 986-988       
   ADJ_E1 989-991           ADJ_E2 992-994           ADJ_EHI 995-997       
   ADJ_F1 998-1000          ADJ_F2 1001-1003         ADJ_FHI 1004-1006     
   ADJ_G1 1007-1009         ADJ_G2 1010-1012         ADJ_GHI 1013-1015     
   ADJ_H1 1016-1018         ADJ_H2 1019-1021         ADJ_HHI 1022-1024     
   ADJ_I1 1025-1027         ADJ_I2 1028-1030         ADJ_IHI 1031-1033     
   ADJ_J1 1034-1036         ADJ_J2 1037-1039         ADJ_JHI 1040-1042     
   ADJ_K1 1043-1045         ADJ_K2 1046-1048         ADJ_KHI 1049-1051     
   ADJ_L1 1052-1054         ADJ_L2 1055-1057         ADJ_LHI 1058-1060     
   ADJ_M1 1061-1063         ADJ_M2 1064-1066         ADJ_MHI 1067-1069     
   ADJ_N1 1070-1072         ADJ_N2 1073-1075         ADJ_NHI 1076-1078     
   ADJ_O1 1079-1081         ADJ_O2 1082-1084         ADJ_OHI 1085-1087     
   ADJ_P1 1088-1090         ADJ_P2 1091-1093         ADJ_PHI 1094-1096     
   ADJ_Q1 1097-1099         ADJ_Q2 1100-1102         ADJ_QHI 1103-1105     
   ADJ_R1 1106-1108         ADJ_R2 1109-1111         ADJ_RHI 1112-1114     
   ADJ_S1 1115-1117         ADJ_S2 1118-1120         ADJ_SHI 1121-1123     
   ADJ_T1 1124-1126         ADJ_T2 1127-1129         ADJ_THI 1130-1132     
   ADJ_U1 1133-1135         ADJ_U2 1136-1138         ADJ_UHI 1139-1141     
   BASADJ1 1142-1144        BASADJ2 1145-1147        BASADJHI 1148-1150    
   BASE1 1151-1153          BASE2 1154-1156          BASEHI 1157-1159      
   BASLN1 1160-1162         BASLN2 1163-1165         BASLNHI 1166-1168     
   ADJOFS1 1169-1171        ADJOFS2 1172-1174        ADJOFSHI 1175-1177    
   ADJS_B1 1178-1180        ADJS_B2 1181-1183        ADJS_BHI 1184-1186    
   ADJS_C1 1187-1189        ADJS_C2 1190-1192        ADJS_CHI 1193-1195    
   ADJS_D1 1196-1198        ADJS_D2 1199-1201        ADJS_DHI 1202-1204    
   ADJS_E1 1205-1207        ADJS_E2 1208-1210        ADJS_EHI 1211-1213    
   ADJS_F1 1214-1216        ADJS_F2 1217-1219        ADJS_FHI 1220-1222    
   ADJS_G1 1223-1225        ADJS_G2 1226-1228        ADJS_GHI 1229-1231    
   ADJS_H1 1232-1234        ADJS_H2 1235-1237        ADJS_HHI 1238-1240    
   ADJS_I1 1241-1243        ADJS_I2 1244-1246        ADJS_IHI 1247-1249    
   ADJS_J1 1250-1252        ADJS_J2 1253-1255        ADJS_JHI 1256-1258    
   ADJS_K1 1259-1261        ADJS_K2 1262-1264        ADJS_KHI 1265-1267    
   ADJS_L1 1268-1270        ADJS_L2 1271-1273        ADJS_LHI 1274-1276    
   ADJS_M1 1277-1279        ADJS_M2 1280-1282        ADJS_MHI 1283-1285    
   ADJS_N1 1286-1288        ADJS_N2 1289-1291        ADJS_NHI 1292-1294    
   ADJS_O1 1295-1297        ADJS_O2 1298-1300        ADJS_OHI 1301-1303    
   ADJS_P1 1304-1306        ADJS_P2 1307-1309        ADJS_PHI 1310-1312    
   ADJS_Q1 1313-1315        ADJS_Q2 1316-1318        ADJS_QHI 1319-1321    
   ADJS_R1 1322-1324        ADJS_R2 1325-1327        ADJS_RHI 1328-1330    
   ADJS_S1 1331-1333        ADJS_S2 1334-1336        ADJS_SHI 1337-1339    
   ADJS_T1 1340-1342        ADJS_T2 1343-1345        ADJS_THI 1346-1348    
   ADJS_U1 1349-1351        ADJS_U2 1352-1354        ADJS_UHI 1355-1357    
   BASADS1 1358-1360        BASADS2 1361-1363        BASADSHI 1364-1366    
   BASES1 1367-1369         BASES2 1370-1372         BASESHI 1373-1375     
   BASLNS1 1376-1378        BASLNS2 1379-1381        BASLNSHI 1382-1384    
   ADJOFR1 1385-1387        ADJOFR2 1388-1390        ADJOFRHI 1391-1393    
   ADJR_B1 1394-1396        ADJR_B2 1397-1399        ADJR_BHI 1400-1402    
   ADJR_C1 1403-1405        ADJR_C2 1406-1408        ADJR_CHI 1409-1411    
   ADJR_D1 1412-1414        ADJR_D2 1415-1417        ADJR_DHI 1418-1420    
   ADJR_E1 1421-1423        ADJR_E2 1424-1426        ADJR_EHI 1427-1429    
   ADJR_F1 1430-1432        ADJR_F2 1433-1435        ADJR_FHI 1436-1438    
   ADJR_G1 1439-1441        ADJR_G2 1442-1444        ADJR_GHI 1445-1447    
   ADJR_H1 1448-1450        ADJR_H2 1451-1453        ADJR_HHI 1454-1456    
   ADJR_I1 1457-1459        ADJR_I2 1460-1462        ADJR_IHI 1463-1465    
   ADJR_J1 1466-1468        ADJR_J2 1469-1471        ADJR_JHI 1472-1474    
   ADJR_K1 1475-1477        ADJR_K2 1478-1480        ADJR_KHI 1481-1483    
   ADJR_L1 1484-1486        ADJR_L2 1487-1489        ADJR_LHI 1490-1492    
   ADJR_M1 1493-1495        ADJR_M2 1496-1498        ADJR_MHI 1499-1501    
   ADJR_N1 1502-1504        ADJR_N2 1505-1507        ADJR_NHI 1508-1510    
   ADJR_O1 1511-1513        ADJR_O2 1514-1516        ADJR_OHI 1517-1519    
   ADJR_P1 1520-1522        ADJR_P2 1523-1525        ADJR_PHI 1526-1528    
   ADJR_Q1 1529-1531        ADJR_Q2 1532-1534        ADJR_QHI 1535-1537    
   ADJR_R1 1538-1540        ADJR_R2 1541-1543        ADJR_RHI 1544-1546    
   ADJR_S1 1547-1549        ADJR_S2 1550-1552        ADJR_SHI 1553-1555    
   ADJR_T1 1556-1558        ADJR_T2 1559-1561        ADJR_THI 1562-1564    
   ADJR_U1 1565-1567        ADJR_U2 1568-1570        ADJR_UHI 1571-1573    
   BASADR1 1574-1576        BASADR2 1577-1579        BASADRHI 1580-1582    
   BASER1 1583-1585         BASER2 1586-1588         BASERHI 1589-1591     
   BASLNR1 1592-1594        BASLNR2 1595-1597        BASLNRHI 1598-1600    
   ADJOFC1 1601-1603        ADJOFC2 1604-1606        ADJOFCHI 1607-1609    
   ADJC_B1 1610-1612        ADJC_B2 1613-1615        ADJC_BHI 1616-1618    
   ADJC_C1 1619-1621        ADJC_C2 1622-1624        ADJC_CHI 1625-1627    
   ADJC_D1 1628-1630        ADJC_D2 1631-1633        ADJC_DHI 1634-1636    
   ADJC_E1 1637-1639        ADJC_E2 1640-1642        ADJC_EHI 1643-1645    
   ADJC_F1 1646-1648        ADJC_F2 1649-1651        ADJC_FHI 1652-1654    
   ADJC_G1 1655-1657        ADJC_G2 1658-1660        ADJC_GHI 1661-1663    
   ADJC_H1 1664-1666        ADJC_H2 1667-1669        ADJC_HHI 1670-1672    
   ADJC_I1 1673-1675        ADJC_I2 1676-1678        ADJC_IHI 1679-1681    
   ADJC_J1 1682-1684        ADJC_J2 1685-1687        ADJC_JHI 1688-1690    
   ADJC_K1 1691-1693        ADJC_K2 1694-1696        ADJC_KHI 1697-1699    
   ADJC_L1 1700-1702        ADJC_L2 1703-1705        ADJC_LHI 1706-1708    
   ADJC_M1 1709-1711        ADJC_M2 1712-1714        ADJC_MHI 1715-1717    
   ADJC_N1 1718-1720        ADJC_N2 1721-1723        ADJC_NHI 1724-1726    
   ADJC_O1 1727-1729        ADJC_O2 1730-1732        ADJC_OHI 1733-1735    
   ADJC_P1 1736-1738        ADJC_P2 1739-1741        ADJC_PHI 1742-1744    
   ADJC_Q1 1745-1747        ADJC_Q2 1748-1750        ADJC_QHI 1751-1753    
   ADJC_R1 1754-1756        ADJC_R2 1757-1759        ADJC_RHI 1760-1762    
   ADJC_S1 1763-1765        ADJC_S2 1766-1768        ADJC_SHI 1769-1771    
   ADJC_T1 1772-1774        ADJC_T2 1775-1777        ADJC_THI 1778-1780    
   ADJC_U1 1781-1783        ADJC_U2 1784-1786        ADJC_UHI 1787-1789    
   BASADC1 1790-1792        BASADC2 1793-1795        BASADCHI 1796-1798    
   BASEC1 1799-1801         BASEC2 1802-1804         BASECHI 1805-1807     
   BASLNC1 1808-1810        BASLNC2 1811-1813        BASLNCHI 1814-1816    
   ADJOFU1 1817-1819        ADJOFU2 1820-1822        ADJOFUHI 1823-1825    
   ADJU_B1 1826-1828        ADJU_B2 1829-1831        ADJU_BHI 1832-1834    
   ADJU_C1 1835-1837        ADJU_C2 1838-1840        ADJU_CHI 1841-1843    
   ADJU_D1 1844-1846        ADJU_D2 1847-1849        ADJU_DHI 1850-1852    
   ADJU_E1 1853-1855        ADJU_E2 1856-1858        ADJU_EHI 1859-1861    
   ADJU_F1 1862-1864        ADJU_F2 1865-1867        ADJU_FHI 1868-1870    
   ADJU_G1 1871-1873        ADJU_G2 1874-1876        ADJU_GHI 1877-1879    
   ADJU_H1 1880-1882        ADJU_H2 1883-1885        ADJU_HHI 1886-1888    
   ADJU_I1 1889-1891        ADJU_I2 1892-1894        ADJU_IHI 1895-1897    
   ADJU_J1 1898-1900        ADJU_J2 1901-1903        ADJU_JHI 1904-1906    
   ADJU_K1 1907-1909        ADJU_K2 1910-1912        ADJU_KHI 1913-1915    
   ADJU_L1 1916-1918        ADJU_L2 1919-1921        ADJU_LHI 1922-1924    
   ADJU_M1 1925-1927        ADJU_M2 1928-1930        ADJU_MHI 1931-1933    
   ADJU_N1 1934-1936        ADJU_N2 1937-1939        ADJU_NHI 1940-1942    
   ADJU_O1 1943-1945        ADJU_O2 1946-1948        ADJU_OHI 1949-1951    
   ADJU_P1 1952-1954        ADJU_P2 1955-1957        ADJU_PHI 1958-1960    
   ADJU_Q1 1961-1963        ADJU_Q2 1964-1966        ADJU_QHI 1967-1969    
   ADJU_R1 1970-1972        ADJU_R2 1973-1975        ADJU_RHI 1976-1978    
   ADJU_S1 1979-1981        ADJU_S2 1982-1984        ADJU_SHI 1985-1987    
   ADJU_T1 1988-1990        ADJU_T2 1991-1993        ADJU_THI 1994-1996    
   ADJU_U1 1997-1999        ADJU_U2 2000-2002        ADJU_UHI 2003-2005    
   BASADU1 2006-2008        BASADU2 2009-2011        BASADUHI 2012-2014    
   BASEU1 2015-2017         BASEU2 2018-2020         BASEUHI 2021-2023     
   BASLNU1 2024-2026        BASLNU2 2027-2029        BASLNUHI 2030-2032    
   ADJL_B1 2033 (A)         ADJL_B2 2034 (A)         ADJL_BHI 2035 (A)     
   ADJL_C1 2036-2037 (A)    ADJL_C2 2038 (A)         ADJL_CHI 2039-2040 (A)
   ADJL_D1 2041 (A)         ADJL_D2 2042 (A)         ADJL_DHI 2043 (A)     
   ADJL_E1 2044 (A)         ADJL_E2 2045 (A)         ADJL_EHI 2046 (A)     
   ADJL_F1 2047 (A)         ADJL_F2 2048 (A)         ADJL_FHI 2049 (A)     
   ADJL_G1 2050 (A)         ADJL_G2 2051 (A)         ADJL_GHI 2052 (A)     
   ADJL_H1 2053-2054 (A)    ADJL_H2 2055 (A)         ADJL_HHI 2056-2057 (A)
   ADJL_I1 2058 (A)         ADJL_I2 2059 (A)         ADJL_IHI 2060 (A)     
   ADJL_J1 2061 (A)         ADJL_J2 2062 (A)         ADJL_JHI 2063 (A)     
   ADJL_K1 2064 (A)         ADJL_K2 2065 (A)         ADJL_KHI 2066 (A)     
   ADJL_L1 2067 (A)         ADJL_L2 2068 (A)         ADJL_LHI 2069 (A)     
   ADJL_M1 2070 (A)         ADJL_M2 2071 (A)         ADJL_MHI 2072 (A)     
   ADJL_N1 2073 (A)         ADJL_N2 2074 (A)         ADJL_NHI 2075 (A)     
   ADJL_O1 2076 (A)         ADJL_O2 2077 (A)         ADJL_OHI 2078 (A)     
   ADJL_P1 2079 (A)         ADJL_P2 2080 (A)         ADJL_PHI 2081 (A)     
   ADJL_Q1 2082 (A)         ADJL_Q2 2083 (A)         ADJL_QHI 2084 (A)     
   ADJL_R1 2085 (A)         ADJL_R2 2086 (A)         ADJL_RHI 2087 (A)     
   ADJL_S1 2088 (A)         ADJL_S2 2089 (A)         ADJL_SHI 2090 (A)     
   ADJL_T1 2091 (A)         ADJL_T2 2092 (A)         ADJL_THI 2093 (A)     
   ADJL_U1 2094 (A)         ADJL_U2 2095 (A)         ADJL_UHI 2096 (A)     
   BASEL1 2097 (A)          BASEL2 2098 (A)          BASELHI 2099 (A)      
   ADSL_B1 2100 (A)         ADSL_B2 2101 (A)         ADSL_BHI 2102 (A)     
   ADSL_C1 2103-2104 (A)    ADSL_C2 2105 (A)         ADSL_CHI 2106-2107 (A)
   ADSL_D1 2108 (A)         ADSL_D2 2109 (A)         ADSL_DHI 2110 (A)     
   ADSL_E1 2111 (A)         ADSL_E2 2112 (A)         ADSL_EHI 2113 (A)     
   ADSL_F1 2114 (A)         ADSL_F2 2115 (A)         ADSL_FHI 2116 (A)     
   ADSL_G1 2117 (A)         ADSL_G2 2118 (A)         ADSL_GHI 2119 (A)     
   ADSL_H1 2120-2121 (A)    ADSL_H2 2122 (A)         ADSL_HHI 2123-2124 (A)
   ADSL_I1 2125 (A)         ADSL_I2 2126 (A)         ADSL_IHI 2127 (A)     
   ADSL_J1 2128 (A)         ADSL_J2 2129 (A)         ADSL_JHI 2130 (A)     
   ADSL_K1 2131 (A)         ADSL_K2 2132 (A)         ADSL_KHI 2133 (A)     
   ADSL_L1 2134 (A)         ADSL_L2 2135 (A)         ADSL_LHI 2136 (A)     
   ADSL_M1 2137 (A)         ADSL_M2 2138 (A)         ADSL_MHI 2139 (A)     
   ADSL_N1 2140 (A)         ADSL_N2 2141 (A)         ADSL_NHI 2142 (A)     
   ADSL_O1 2143 (A)         ADSL_O2 2144 (A)         ADSL_OHI 2145 (A)     
   ADSL_P1 2146 (A)         ADSL_P2 2147 (A)         ADSL_PHI 2148 (A)     
   ADSL_Q1 2149 (A)         ADSL_Q2 2150 (A)         ADSL_QHI 2151 (A)     
   ADSL_R1 2152 (A)         ADSL_R2 2153 (A)         ADSL_RHI 2154 (A)     
   ADSL_S1 2155 (A)         ADSL_S2 2156 (A)         ADSL_SHI 2157 (A)     
   ADSL_T1 2158 (A)         ADSL_T2 2159 (A)         ADSL_THI 2160 (A)     
   ADSL_U1 2161 (A)         ADSL_U2 2162 (A)         ADSL_UHI 2163 (A)     
   BASESL1 2164 (A)         BASESL2 2165 (A)         BASESLHI 2166 (A)     
   ADRL_B1 2167 (A)         ADRL_B2 2168 (A)         ADRL_BHI 2169 (A)     
   ADRL_C1 2170-2171 (A)    ADRL_C2 2172 (A)         ADRL_CHI 2173-2174 (A)
   ADRL_D1 2175 (A)         ADRL_D2 2176 (A)         ADRL_DHI 2177 (A)     
   ADRL_E1 2178 (A)         ADRL_E2 2179 (A)         ADRL_EHI 2180 (A)     
   ADRL_F1 2181 (A)         ADRL_F2 2182 (A)         ADRL_FHI 2183 (A)     
   ADRL_G1 2184 (A)         ADRL_G2 2185 (A)         ADRL_GHI 2186 (A)     
   ADRL_H1 2187 (A)         ADRL_H2 2188 (A)         ADRL_HHI 2189 (A)     
   ADRL_I1 2190 (A)         ADRL_I2 2191 (A)         ADRL_IHI 2192 (A)     
   ADRL_J1 2193 (A)         ADRL_J2 2194 (A)         ADRL_JHI 2195 (A)     
   ADRL_K1 2196 (A)         ADRL_K2 2197 (A)         ADRL_KHI 2198 (A)     
   ADRL_L1 2199 (A)         ADRL_L2 2200 (A)         ADRL_LHI 2201 (A)     
   ADRL_M1 2202 (A)         ADRL_M2 2203 (A)         ADRL_MHI 2204 (A)     
   ADRL_N1 2205 (A)         ADRL_N2 2206 (A)         ADRL_NHI 2207 (A)     
   ADRL_O1 2208 (A)         ADRL_O2 2209 (A)         ADRL_OHI 2210 (A)     
   ADRL_P1 2211 (A)         ADRL_P2 2212 (A)         ADRL_PHI 2213 (A)     
   ADRL_Q1 2214 (A)         ADRL_Q2 2215 (A)         ADRL_QHI 2216 (A)     
   ADRL_R1 2217 (A)         ADRL_R2 2218 (A)         ADRL_RHI 2219 (A)     
   ADRL_S1 2220 (A)         ADRL_S2 2221 (A)         ADRL_SHI 2222 (A)     
   ADRL_T1 2223 (A)         ADRL_T2 2224 (A)         ADRL_THI 2225 (A)     
   ADRL_U1 2226 (A)         ADRL_U2 2227 (A)         ADRL_UHI 2228 (A)     
   BASERL1 2229 (A)         BASERL2 2230 (A)         BASERLHI 2231 (A)     
   ADCL_B1 2232 (A)         ADCL_B2 2233 (A)         ADCL_BHI 2234 (A)     
   ADCL_C1 2235 (A)         ADCL_C2 2236 (A)         ADCL_CHI 2237 (A)     
   ADCL_D1 2238 (A)         ADCL_D2 2239 (A)         ADCL_DHI 2240 (A)     
   ADCL_E1 2241 (A)         ADCL_E2 2242 (A)         ADCL_EHI 2243 (A)     
   ADCL_F1 2244 (A)         ADCL_F2 2245 (A)         ADCL_FHI 2246 (A)     
   ADCL_G1 2247 (A)         ADCL_G2 2248 (A)         ADCL_GHI 2249 (A)     
   ADCL_H1 2250 (A)         ADCL_H2 2251 (A)         ADCL_HHI 2252 (A)     
   ADCL_I1 2253 (A)         ADCL_I2 2254 (A)         ADCL_IHI 2255 (A)     
   ADCL_J1 2256 (A)         ADCL_J2 2257 (A)         ADCL_JHI 2258 (A)     
   ADCL_K1 2259 (A)         ADCL_K2 2260 (A)         ADCL_KHI 2261 (A)     
   ADCL_L1 2262 (A)         ADCL_L2 2263 (A)         ADCL_LHI 2264 (A)     
   ADCL_M1 2265 (A)         ADCL_M2 2266 (A)         ADCL_MHI 2267 (A)     
   ADCL_N1 2268 (A)         ADCL_N2 2269 (A)         ADCL_NHI 2270 (A)     
   ADCL_O1 2271 (A)         ADCL_O2 2272 (A)         ADCL_OHI 2273 (A)     
   ADCL_P1 2274 (A)         ADCL_P2 2275 (A)         ADCL_PHI 2276 (A)     
   ADCL_Q1 2277 (A)         ADCL_Q2 2278 (A)         ADCL_QHI 2279 (A)     
   ADCL_R1 2280 (A)         ADCL_R2 2281 (A)         ADCL_RHI 2282 (A)     
   ADCL_S1 2283 (A)         ADCL_S2 2284 (A)         ADCL_SHI 2285 (A)     
   ADCL_T1 2286 (A)         ADCL_T2 2287 (A)         ADCL_THI 2288 (A)     
   ADCL_U1 2289 (A)         ADCL_U2 2290 (A)         ADCL_UHI 2291 (A)     
   BASECL1 2292 (A)         BASECL2 2293 (A)         BASECLHI 2294 (A)     
   ADUL_B1 2295 (A)         ADUL_B2 2296 (A)         ADUL_BHI 2297 (A)     
   ADUL_C1 2298 (A)         ADUL_C2 2299 (A)         ADUL_CHI 2300 (A)     
   ADUL_D1 2301 (A)         ADUL_D2 2302 (A)         ADUL_DHI 2303 (A)     
   ADUL_E1 2304 (A)         ADUL_E2 2305 (A)         ADUL_EHI 2306 (A)     
   ADUL_F1 2307 (A)         ADUL_F2 2308 (A)         ADUL_FHI 2309 (A)     
   ADUL_G1 2310 (A)         ADUL_G2 2311 (A)         ADUL_GHI 2312 (A)     
   ADUL_H1 2313 (A)         ADUL_H2 2314 (A)         ADUL_HHI 2315 (A)     
   ADUL_I1 2316 (A)         ADUL_I2 2317 (A)         ADUL_IHI 2318 (A)     
   ADUL_J1 2319 (A)         ADUL_J2 2320 (A)         ADUL_JHI 2321 (A)     
   ADUL_K1 2322 (A)         ADUL_K2 2323 (A)         ADUL_KHI 2324 (A)     
   ADUL_L1 2325 (A)         ADUL_L2 2326 (A)         ADUL_LHI 2327 (A)     
   ADUL_M1 2328 (A)         ADUL_M2 2329 (A)         ADUL_MHI 2330 (A)     
   ADUL_N1 2331 (A)         ADUL_N2 2332 (A)         ADUL_NHI 2333 (A)     
   ADUL_O1 2334 (A)         ADUL_O2 2335 (A)         ADUL_OHI 2336 (A)     
   ADUL_P1 2337 (A)         ADUL_P2 2338 (A)         ADUL_PHI 2339 (A)     
   ADUL_Q1 2340 (A)         ADUL_Q2 2341 (A)         ADUL_QHI 2342 (A)     
   ADUL_R1 2343 (A)         ADUL_R2 2344 (A)         ADUL_RHI 2345 (A)     
   ADUL_S1 2346 (A)         ADUL_S2 2347 (A)         ADUL_SHI 2348 (A)     
   ADUL_T1 2349 (A)         ADUL_T2 2350 (A)         ADUL_THI 2351 (A)     
   ADUL_U1 2352 (A)         ADUL_U2 2353 (A)         ADUL_UHI 2354 (A)     
   BASEUL1 2355 (A)         BASEUL2 2356 (A)         BASEULHI 2357 (A)     
   GDLINE1 2358-2362 (A)    GDLINE2 2363-2367 (A)    GDSTAT1 2368-2372 (A) 
   GDSTAT2 2373-2377 (A)    GDREF1 2378-2382 (A)     GDREF2 2383 (A)       
   GDCROS1 2384-2388 (A)    GDCROS2 2389 (A)         GDUNDR1 2390 (A)      
   GDUNDR2 2391 (A)         GDLINEHI 2392-2396 (A)   GDSTATHI 2397-2401 (A)
   GDREFHI 2402-2406 (A)    GDCROSHI 2407-2411 (A)   GDUNDRHI 2412 (A)     
   STA1_1 2413-2424 (A)     STA1_2 2425-2433 (A)     STA1_3 2434-2442 (A)  
   STA1_4 2443-2451 (A)     STA1_5 2452-2460 (A)     STA1_6 2461-2469 (A)  
   STA1_7 2470-2478 (A)     STA1_8 2479-2487 (A)     STA1_9 2488-2496 (A)  
   STA1_10 2497-2505 (A)    STA1_11 2506-2514 (A)    STA1_12 2515-2523 (A) 
   STA1_13 2524-2532 (A)    STA1_14 2533-2541 (A)    STA1_15 2542-2550 (A) 
   STA1_16 2551-2559 (A)    STA1_17 2560-2568 (A)    STA1_18 2569-2577 (A) 
   STA1_19 2578-2586 (A)    STA1_20 2587-2595 (A)    STA1_21 2596-2604 (A) 
   STA1_22 2605-2613 (A)    STA1_23 2614-2622 (A)    STA1_24 2623-2631 (A) 
   STA1_25 2632-2640 (A)    STA1_26 2641-2649 (A)    STA1_27 2650-2658 (A) 
   STA1_28 2659-2667 (A)    STA1_29 2668-2676 (A)    STA1_30 2677-2685 (A) 
   STA1_31 2686-2694 (A)    STA1_32 2695-2700 (A)    STA1_33 2701-2706 (A) 
   STA1_34 2707-2712 (A)    STA1_35 2713-2718 (A)    STA1_36 2719-2724 (A) 
   STA1_37 2725-2730 (A)    STA1_38 2731-2736 (A)    STA1_39 2737-2742 (A) 
   STA1_40 2743-2748 (A)    STA1_41 2749-2755 (A)    STA1_42 2756-2762 (A) 
   STA1_43 2763-2769 (A)    STA1_44 2770-2776 (A)    STA1_45 2777-2783 (A) 
   STA1_46 2784-2790 (A)    STA1_47 2791-2798 (A)    STA2_1 2799-2809 (A)  
   STA2_2 2810-2818 (A)     STA2_3 2819-2825 (A)     STA2_4 2826-2832 (A)  
   STA2_5 2833-2839 (A)     STA2_6 2840-2846 (A)     STA2_7 2847-2853 (A)  
   STA2_8 2854-2860 (A)     STA2_9 2861 (A)          STA2_10 2862 (A)      
   STA2_11 2863 (A)         STA2_12 2864 (A)         STA2_13 2865 (A)      
   STA2_14 2866 (A)         STA2_15 2867 (A)         STA2_16 2868 (A)      
   STA2_17 2869 (A)         STA2_18 2870 (A)         STA2_19 2871 (A)      
   STA2_20 2872 (A)         STA2_21 2873 (A)         STA2_22 2874 (A)      
   STA2_23 2875 (A)         STA2_24 2876 (A)         STA2_25 2877 (A)      
   STA2_26 2878 (A)         STA2_27 2879 (A)         STA2_28 2880 (A)      
   STA2_29 2881 (A)         STA2_30 2882 (A)         STA2_31 2883 (A)      
   STA2_32 2884 (A)         STA2_33 2885 (A)         STA2_34 2886 (A)      
   STA2_35 2887 (A)         STA2_36 2888 (A)         STA2_37 2889 (A)      
   STA2_38 2890 (A)         STA2_39 2891 (A)         STA2_40 2892 (A)      
   STA2_41 2893 (A)         STA2_42 2894 (A)         STA2_43 2895 (A)      
   STA2_44 2896 (A)         STA2_45 2897 (A)         STA2_46 2898 (A)      
   STA2_47 2899 (A)         STA3_1 2900-2907 (A)     STA3_2 2908 (A)       
   STA3_3 2909 (A)          STA3_4 2910 (A)          STA3_5 2911 (A)       
   STA3_6 2912 (A)          STA3_7 2913 (A)          STA3_8 2914 (A)       
   STA3_9 2915 (A)          STA3_10 2916 (A)         STA3_11 2917 (A)      
   STA3_12 2918 (A)         STA3_13 2919 (A)         STA3_14 2920 (A)      
   STA3_15 2921 (A)         STA3_16 2922 (A)         STA3_17 2923 (A)      
   STA3_18 2924 (A)         STA3_19 2925 (A)         STA3_20 2926 (A)      
   STA3_21 2927 (A)         STA3_22 2928 (A)         STA3_23 2929 (A)      
   STA3_24 2930 (A)         STA3_25 2931 (A)         STA3_26 2932 (A)      
   STA3_27 2933 (A)         STA3_28 2934 (A)         STA3_29 2935 (A)      
   STA3_30 2936 (A)         STA3_31 2937 (A)         STA3_32 2938 (A)      
   STA3_33 2939 (A)         STA3_34 2940 (A)         STA3_35 2941 (A)      
   STA3_36 2942 (A)         STA3_37 2943 (A)         STA3_38 2944 (A)      
   STA3_39 2945 (A)         STA3_40 2946 (A)         STA3_41 2947 (A)      
   STA3_42 2948 (A)         STA3_43 2949 (A)         STA3_44 2950 (A)      
   STA3_45 2951 (A)         STA3_46 2952 (A)         STA3_47 2953 (A)      
   NWSTAT1 2954-2965 (A)    NWSTAT2 2966-2976 (A)    NWSTAT3 2977-2985 (A) 
   NWSTAT4 2986-2994 (A)    NWSTAT5 2995-3002 (A)    NWSTAT6 3003-3010 (A) 
   NWSTAT7 3011-3017 (A)    TTSC1_1 3018-3023 (A)    TTSC1_2 3024-3029 (A) 
   TTSC1_3 3030-3036 (A)    TTSC1_4 3037-3042 (A)    TTSC1_5 3043-3048 (A) 
   TTSC1_6 3049-3054 (A)    TTSC1_7 3055-3060 (A)    TTSC1_8 3061-3066 (A) 
   TTSC1_9 3067-3072 (A)    TTSC1_10 3073-3078 (A)   TTSC1_11 3079-3084 (A)
   TTSC1_12 3085-3090 (A)   TTSC1_13 3091-3096 (A)   TTSC1_14 3097-3102 (A)
   TTSC1_15 3103-3108 (A)   TTSC1_16 3109-3114 (A)   TTSC1_17 3115-3120 (A)
   TTSC1_18 3121-3126 (A)   TTSC1_19 3127-3132 (A)   TTSC1_20 3133-3138 (A)
   TTSC1_21 3139-3144 (A)   TTSC1_22 3145-3150 (A)   TTSC1_23 3151-3156 (A)
   TTSC1_24 3157-3162 (A)   TTSC1_25 3163-3168 (A)   TTSC1_26 3169-3174 (A)
   TTSC1_27 3175-3180 (A)   TTSC1_28 3181-3186 (A)   TTSC1_29 3187-3192 (A)
   TTSC1_30 3193-3198 (A)   TTSC1_31 3199-3204 (A)   TTSC1_32 3205-3210 (A)
   TTSC1_33 3211-3216 (A)   TTSC1_34 3217-3222 (A)   TTSC1_35 3223-3228 (A)
   TTSC1_36 3229-3234 (A)   TTSC1_37 3235-3240 (A)   TTSC1_38 3241-3246 (A)
   TTSC1_39 3247-3252 (A)   TTSC1_40 3253-3258 (A)   TTSC1_41 3259-3263 (A)
   TTSC1_42 3264-3268 (A)   TTSC1_43 3269-3273 (A)   TTSC1_44 3274-3278 (A)
   TTSC1_45 3279-3283 (A)   TTSC1_46 3284-3288 (A)   TTSC1_47 3289-3293 (A)
   TTSC2_1 3294-3301 (A)    TTSC2_2 3302-3307 (A)    TTSC2_3 3308-3312 (A) 
   TTSC2_4 3313-3317 (A)    TTSC2_5 3318-3322 (A)    TTSC2_6 3323-3328 (A) 
   TTSC2_7 3329-3334 (A)    TTSC2_8 3335-3340 (A)    TTSC2_9 3341 (A)      
   TTSC2_10 3342 (A)        TTSC2_11 3343 (A)        TTSC2_12 3344 (A)     
   TTSC2_13 3345 (A)        TTSC2_14 3346 (A)        TTSC2_15 3347 (A)     
   TTSC2_16 3348 (A)        TTSC2_17 3349 (A)        TTSC2_18 3350 (A)     
   TTSC2_19 3351 (A)        TTSC2_20 3352 (A)        TTSC2_21 3353 (A)     
   TTSC2_22 3354 (A)        TTSC2_23 3355 (A)        TTSC2_24 3356 (A)     
   TTSC2_25 3357 (A)        TTSC2_26 3358 (A)        TTSC2_27 3359 (A)     
   TTSC2_28 3360 (A)        TTSC2_29 3361 (A)        TTSC2_30 3362 (A)     
   TTSC2_31 3363 (A)        TTSC2_32 3364 (A)        TTSC2_33 3365 (A)     
   TTSC2_34 3366 (A)        TTSC2_35 3367 (A)        TTSC2_36 3368 (A)     
   TTSC2_37 3369 (A)        TTSC2_38 3370 (A)        TTSC2_39 3371 (A)     
   TTSC2_40 3372 (A)        TTSC2_41 3373 (A)        TTSC2_42 3374 (A)     
   TTSC2_43 3375 (A)        TTSC2_44 3376 (A)        TTSC2_45 3377 (A)     
   TTSC2_46 3378 (A)        TTSC2_47 3379 (A)        TTSC3_1 3380-3385 (A) 
   TTSC3_2 3386 (A)         TTSC3_3 3387 (A)         TTSC3_4 3388 (A)      
   TTSC3_5 3389 (A)         TTSC3_6 3390 (A)         TTSC3_7 3391 (A)      
   TTSC3_8 3392 (A)         TTSC3_9 3393 (A)         TTSC3_10 3394 (A)     
   TTSC3_11 3395 (A)        TTSC3_12 3396 (A)        TTSC3_13 3397 (A)     
   TTSC3_14 3398 (A)        TTSC3_15 3399 (A)        TTSC3_16 3400 (A)     
   TTSC3_17 3401 (A)        TTSC3_18 3402 (A)        TTSC3_19 3403 (A)     
   TTSC3_20 3404 (A)        TTSC3_21 3405 (A)        TTSC3_22 3406 (A)     
   TTSC3_23 3407 (A)        TTSC3_24 3408 (A)        TTSC3_25 3409 (A)     
   TTSC3_26 3410 (A)        TTSC3_27 3411 (A)        TTSC3_28 3412 (A)     
   TTSC3_29 3413 (A)        TTSC3_30 3414 (A)        TTSC3_31 3415 (A)     
   TTSC3_32 3416 (A)        TTSC3_33 3417 (A)        TTSC3_34 3418 (A)     
   TTSC3_35 3419 (A)        TTSC3_36 3420 (A)        TTSC3_37 3421 (A)     
   TTSC3_38 3422 (A)        TTSC3_39 3423 (A)        TTSC3_40 3424 (A)     
   TTSC3_41 3425 (A)        TTSC3_42 3426 (A)        TTSC3_43 3427 (A)     
   TTSC3_44 3428 (A)        TTSC3_45 3429 (A)        TTSC3_46 3430 (A)     
   TTSC3_47 3431 (A)        SMAX1 3432-3439          SMAX2 3440-3447       
   SMAX3 3448-3455          SMAX4 3456-3463          SMAX5 3464-3471       
   SMAX6 3472-3479          SMAX7 3480-3487          SMAX8 3488-3495       
   SMAX9 3496-3503          SMAX10 3504-3511         SMAX11 3512-3519      
   SMAX12 3520-3527         SMAX13 3528-3535         SMAX14 3536-3543      
   SMAX15 3544-3551         SMAX16 3552-3559         SMAX17 3560-3567      
   SMAX18 3568-3575         SMAX19 3576-3583         SMAX20 3584-3591      
   SMAX21 3592-3599         SMAX22 3600-3607         SMAX23 3608-3615      
   SMAX24 3616-3623         SMAX25 3624-3631         SMAX26 3632-3639      
   SMAX27 3640-3647         SMAX28 3648-3655         SMAX29 3656-3663      
   SMAX30 3664-3671         SMAX31 3672-3679         SMAX32 3680-3687      
   SMAX33 3688-3695         SMAX34 3696-3703         SMAX35 3704-3711      
   SMAX36 3712-3719         SMAX37 3720-3727         SMAX38 3728-3735      
   SMAX39 3736-3743         SMAX40 3744-3751         SMAX41 3752-3759      
   SMAX42 3760-3767         SMAX43 3768-3775         SMAX44 3776-3783      
   SMAX45 3784-3791         SMAX46 3792-3799         SMAX47 3800-3807      
   SMIN1 3808-3815          SMIN2 3816-3823          SMIN3 3824-3831       
   SMIN4 3832-3839          SMIN5 3840-3847          SMIN6 3848-3855       
   SMIN7 3856-3863          SMIN8 3864-3871          SMIN9 3872-3879       
   SMIN10 3880-3887         SMIN11 3888-3895         SMIN12 3896-3903      
   SMIN13 3904-3911         SMIN14 3912-3919         SMIN15 3920-3927      
   SMIN16 3928-3935         SMIN17 3936-3943         SMIN18 3944-3951      
   SMIN19 3952-3959         SMIN20 3960-3967         SMIN21 3968-3975      
   SMIN22 3976-3983         SMIN23 3984-3991         SMIN24 3992-3999      
   SMIN25 4000-4007         SMIN26 4008-4015         SMIN27 4016-4023      
   SMIN28 4024-4031         SMIN29 4032-4039         SMIN30 4040-4047      
   SMIN31 4048-4055         SMIN32 4056-4063         SMIN33 4064-4071      
   SMIN34 4072-4079         SMIN35 4080-4087         SMIN36 4088-4095      
   SMIN37 4096-4103         SMIN38 4104-4111         SMIN39 4112-4119      
   SMIN40 4120-4127         SMIN41 4128-4135         SMIN42 4136-4143      
   SMIN43 4144-4151         SMIN44 4152-4159         SMIN45 4160-4167      
   SMIN46 4168-4175         SMIN47 4176-4183         RETEXT1 4184-4222 (A) 
   RETEXT2 4223 (A)         RETEXT3 4224 (A)         RETEXT4 4225-4243 (A) 
   RETEXT5 4244 (A)         RETEXT6 4245 (A) .    


FORMATS
  MINFINML (F9.2) /        MAXFINML (F9.1) / .
   

SAVE OUTFILE='.\corp21nid.sav'.
