/*****************************************************************************************
*                                                                                        *
* This SAS program will extract the United States Sentencing Commission's fiscal year    *
* 2021 Organizational file and create a SAS dataset.                                     *
*                                                                                        *
* Prior to running the program you must update the DAT file location in the FILNAME line *
* to correspond to the location of the file on your computer, replacing the '.' with the *
* folder path location (e.g. 'C:\temp') .                                                *
*                                                                                        *
* You must also update the library location in the LIBNAME statement to correspond to    *
* the folder you want the output file to be located, replacing the '.' with the folder   *
* path location (e.g. 'C:\temp') .                                                       *
*                                                                                        *
*****************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile '.\corp21nid.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library '.' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = corp21nid ;

DATA library.&dataset ;
INFILE datafile LRECL=4245;
INPUT
   ACCEPT  1-3              BUSCLAS  4-7             CANTPAY  8-10         
   CCULPSCO  11-13          CH2APP  14-16            CH8FINGD  17-19       
   CMSRVORD  20-22          COFI  23-25              COMPLY  26-28         
   COMPLYPR  29-31          CRIMPURP  32-34          DETBFINE  35-37       
   DISPOSIT  38-40          EMPLOYNM  41-43          FCULPSCO  44-46       
   FRAUDTYP  47-49          FINSTDS  50-52           HISTORY  53-55        
   HSMISCND  56-58          INCORLOC  59-61          INCORPYR  62-65       
   INDICT  66-68            INPLEA1  69-71           INPLEA2  72-74        
   INPLEA3  75-77           INPLEA4  78-80           INPLEA5  81-83        
   INPLEA6  84-86           INPLEA7  87-89           INPLEA8  90-92        
   INPLEA9  93-95           INPLEA10  96-98          INPLEA11  99-101      
   INPLEA12  102-104        INNOPL1  105-107         INNOPL2  108-110      
   INNOPL3  111-113         INNOPL4  114-116         INNOPL5  117-119      
   INNOPL6  120-122         INNOPL7  123-125         INNOPL8  126-128      
   INNOPL9  129-131         INNOPL10  132-134        INNOPL11  135-137     
   INNOPL12  138-140        JANDC  141-143           NEWCNVTN  144-146     
   NOCOMP  147-149          NOCOUNTS  150-152        NOREAVAR  153-155     
   NOUSTAT  156-158         OBSTRUCT  159-161        OFFLVL  162-164       
   ORDERCE  165-167         ORGTYPE  168-170         OWNSTRCT  171-173     
   PLEA  174-176            PRIMOFF  177-179         PRCIVIL  180-182      
   PRCRIME  183-185         PROBATN  186-188         PROBMON  189-191      
   PSR  192-194             QUARTER  195-197         REAS1  198-200        
   REAS2  201-203           REAS3  204-206           REAS4  207-209        
   REAS5  210-212           REAS6  213-215           REASON3  216-218      
   REASON4  219-221         REASONS  222-224         REMEDORD  225-227     
   SELFREP  228-230         SENTRNGE  231-233        SOURCES  234-236      
   TOLERNCE  237-239        TYPEOTHS  240-242        VICTNOTE  243-245     
   VIOLATE  246-248         AMENDYR  249-252         SENTYR  253-256       
   BASEFINE  257-265        COSTASSM  266-273        DISGORGE  274-281     
   FINOFFST  282-289        FORFEITR  290-298        GLFINMAX  299-307     
   GLFINMIN  308-316        STATMIN  317-324         STATMAX  325-332      
   RESTCAT  333-340         FINECAT  341-348         SUSFNCAT  349-356     
   LCAT1  357-364           LCAT2  365-372           LCATHI  373-380       
   LCATS1  381-388          LCATS2  389-396          LCATSHI  397-404      
   LCATR1  405-412          LCATR2  413-420          LCATRHI  421-428      
   LCATC1  429-436          LCATC2  437-444          LCATCHI  445-452      
   LCATU1  453-460          LCATU2  461-468          LCATUHI  469-476      
   CPIDN  477-483           BUSTEXT $ 484            FINSTXT $ 485         
   OWNSTEXT $ 486           PRMONTXT $ 487-585       ORDERTXT $ 586-747    
   TYPEOTTX $ 748-936       MINFINML  937-944        MAXFINML  945-952     
   ADJOFL1  953-955         ADJOFL2  956-958         ADJOFLHI  959-961     
   ADJ_B1  962-964          ADJ_B2  965-967          ADJ_BHI  968-970      
   ADJ_C1  971-973          ADJ_C2  974-976          ADJ_CHI  977-979      
   ADJ_D1  980-982          ADJ_D2  983-985          ADJ_DHI  986-988      
   ADJ_E1  989-991          ADJ_E2  992-994          ADJ_EHI  995-997      
   ADJ_F1  998-1000         ADJ_F2  1001-1003        ADJ_FHI  1004-1006    
   ADJ_G1  1007-1009        ADJ_G2  1010-1012        ADJ_GHI  1013-1015    
   ADJ_H1  1016-1018        ADJ_H2  1019-1021        ADJ_HHI  1022-1024    
   ADJ_I1  1025-1027        ADJ_I2  1028-1030        ADJ_IHI  1031-1033    
   ADJ_J1  1034-1036        ADJ_J2  1037-1039        ADJ_JHI  1040-1042    
   ADJ_K1  1043-1045        ADJ_K2  1046-1048        ADJ_KHI  1049-1051    
   ADJ_L1  1052-1054        ADJ_L2  1055-1057        ADJ_LHI  1058-1060    
   ADJ_M1  1061-1063        ADJ_M2  1064-1066        ADJ_MHI  1067-1069    
   ADJ_N1  1070-1072        ADJ_N2  1073-1075        ADJ_NHI  1076-1078    
   ADJ_O1  1079-1081        ADJ_O2  1082-1084        ADJ_OHI  1085-1087    
   ADJ_P1  1088-1090        ADJ_P2  1091-1093        ADJ_PHI  1094-1096    
   ADJ_Q1  1097-1099        ADJ_Q2  1100-1102        ADJ_QHI  1103-1105    
   ADJ_R1  1106-1108        ADJ_R2  1109-1111        ADJ_RHI  1112-1114    
   ADJ_S1  1115-1117        ADJ_S2  1118-1120        ADJ_SHI  1121-1123    
   ADJ_T1  1124-1126        ADJ_T2  1127-1129        ADJ_THI  1130-1132    
   ADJ_U1  1133-1135        ADJ_U2  1136-1138        ADJ_UHI  1139-1141    
   BASADJ1  1142-1144       BASADJ2  1145-1147       BASADJHI  1148-1150   
   BASE1  1151-1153         BASE2  1154-1156         BASEHI  1157-1159     
   BASLN1  1160-1162        BASLN2  1163-1165        BASLNHI  1166-1168    
   ADJOFS1  1169-1171       ADJOFS2  1172-1174       ADJOFSHI  1175-1177   
   ADJS_B1  1178-1180       ADJS_B2  1181-1183       ADJS_BHI  1184-1186   
   ADJS_C1  1187-1189       ADJS_C2  1190-1192       ADJS_CHI  1193-1195   
   ADJS_D1  1196-1198       ADJS_D2  1199-1201       ADJS_DHI  1202-1204   
   ADJS_E1  1205-1207       ADJS_E2  1208-1210       ADJS_EHI  1211-1213   
   ADJS_F1  1214-1216       ADJS_F2  1217-1219       ADJS_FHI  1220-1222   
   ADJS_G1  1223-1225       ADJS_G2  1226-1228       ADJS_GHI  1229-1231   
   ADJS_H1  1232-1234       ADJS_H2  1235-1237       ADJS_HHI  1238-1240   
   ADJS_I1  1241-1243       ADJS_I2  1244-1246       ADJS_IHI  1247-1249   
   ADJS_J1  1250-1252       ADJS_J2  1253-1255       ADJS_JHI  1256-1258   
   ADJS_K1  1259-1261       ADJS_K2  1262-1264       ADJS_KHI  1265-1267   
   ADJS_L1  1268-1270       ADJS_L2  1271-1273       ADJS_LHI  1274-1276   
   ADJS_M1  1277-1279       ADJS_M2  1280-1282       ADJS_MHI  1283-1285   
   ADJS_N1  1286-1288       ADJS_N2  1289-1291       ADJS_NHI  1292-1294   
   ADJS_O1  1295-1297       ADJS_O2  1298-1300       ADJS_OHI  1301-1303   
   ADJS_P1  1304-1306       ADJS_P2  1307-1309       ADJS_PHI  1310-1312   
   ADJS_Q1  1313-1315       ADJS_Q2  1316-1318       ADJS_QHI  1319-1321   
   ADJS_R1  1322-1324       ADJS_R2  1325-1327       ADJS_RHI  1328-1330   
   ADJS_S1  1331-1333       ADJS_S2  1334-1336       ADJS_SHI  1337-1339   
   ADJS_T1  1340-1342       ADJS_T2  1343-1345       ADJS_THI  1346-1348   
   ADJS_U1  1349-1351       ADJS_U2  1352-1354       ADJS_UHI  1355-1357   
   BASADS1  1358-1360       BASADS2  1361-1363       BASADSHI  1364-1366   
   BASES1  1367-1369        BASES2  1370-1372        BASESHI  1373-1375    
   BASLNS1  1376-1378       BASLNS2  1379-1381       BASLNSHI  1382-1384   
   ADJOFR1  1385-1387       ADJOFR2  1388-1390       ADJOFRHI  1391-1393   
   ADJR_B1  1394-1396       ADJR_B2  1397-1399       ADJR_BHI  1400-1402   
   ADJR_C1  1403-1405       ADJR_C2  1406-1408       ADJR_CHI  1409-1411   
   ADJR_D1  1412-1414       ADJR_D2  1415-1417       ADJR_DHI  1418-1420   
   ADJR_E1  1421-1423       ADJR_E2  1424-1426       ADJR_EHI  1427-1429   
   ADJR_F1  1430-1432       ADJR_F2  1433-1435       ADJR_FHI  1436-1438   
   ADJR_G1  1439-1441       ADJR_G2  1442-1444       ADJR_GHI  1445-1447   
   ADJR_H1  1448-1450       ADJR_H2  1451-1453       ADJR_HHI  1454-1456   
   ADJR_I1  1457-1459       ADJR_I2  1460-1462       ADJR_IHI  1463-1465   
   ADJR_J1  1466-1468       ADJR_J2  1469-1471       ADJR_JHI  1472-1474   
   ADJR_K1  1475-1477       ADJR_K2  1478-1480       ADJR_KHI  1481-1483   
   ADJR_L1  1484-1486       ADJR_L2  1487-1489       ADJR_LHI  1490-1492   
   ADJR_M1  1493-1495       ADJR_M2  1496-1498       ADJR_MHI  1499-1501   
   ADJR_N1  1502-1504       ADJR_N2  1505-1507       ADJR_NHI  1508-1510   
   ADJR_O1  1511-1513       ADJR_O2  1514-1516       ADJR_OHI  1517-1519   
   ADJR_P1  1520-1522       ADJR_P2  1523-1525       ADJR_PHI  1526-1528   
   ADJR_Q1  1529-1531       ADJR_Q2  1532-1534       ADJR_QHI  1535-1537   
   ADJR_R1  1538-1540       ADJR_R2  1541-1543       ADJR_RHI  1544-1546   
   ADJR_S1  1547-1549       ADJR_S2  1550-1552       ADJR_SHI  1553-1555   
   ADJR_T1  1556-1558       ADJR_T2  1559-1561       ADJR_THI  1562-1564   
   ADJR_U1  1565-1567       ADJR_U2  1568-1570       ADJR_UHI  1571-1573   
   BASADR1  1574-1576       BASADR2  1577-1579       BASADRHI  1580-1582   
   BASER1  1583-1585        BASER2  1586-1588        BASERHI  1589-1591    
   BASLNR1  1592-1594       BASLNR2  1595-1597       BASLNRHI  1598-1600   
   ADJOFC1  1601-1603       ADJOFC2  1604-1606       ADJOFCHI  1607-1609   
   ADJC_B1  1610-1612       ADJC_B2  1613-1615       ADJC_BHI  1616-1618   
   ADJC_C1  1619-1621       ADJC_C2  1622-1624       ADJC_CHI  1625-1627   
   ADJC_D1  1628-1630       ADJC_D2  1631-1633       ADJC_DHI  1634-1636   
   ADJC_E1  1637-1639       ADJC_E2  1640-1642       ADJC_EHI  1643-1645   
   ADJC_F1  1646-1648       ADJC_F2  1649-1651       ADJC_FHI  1652-1654   
   ADJC_G1  1655-1657       ADJC_G2  1658-1660       ADJC_GHI  1661-1663   
   ADJC_H1  1664-1666       ADJC_H2  1667-1669       ADJC_HHI  1670-1672   
   ADJC_I1  1673-1675       ADJC_I2  1676-1678       ADJC_IHI  1679-1681   
   ADJC_J1  1682-1684       ADJC_J2  1685-1687       ADJC_JHI  1688-1690   
   ADJC_K1  1691-1693       ADJC_K2  1694-1696       ADJC_KHI  1697-1699   
   ADJC_L1  1700-1702       ADJC_L2  1703-1705       ADJC_LHI  1706-1708   
   ADJC_M1  1709-1711       ADJC_M2  1712-1714       ADJC_MHI  1715-1717   
   ADJC_N1  1718-1720       ADJC_N2  1721-1723       ADJC_NHI  1724-1726   
   ADJC_O1  1727-1729       ADJC_O2  1730-1732       ADJC_OHI  1733-1735   
   ADJC_P1  1736-1738       ADJC_P2  1739-1741       ADJC_PHI  1742-1744   
   ADJC_Q1  1745-1747       ADJC_Q2  1748-1750       ADJC_QHI  1751-1753   
   ADJC_R1  1754-1756       ADJC_R2  1757-1759       ADJC_RHI  1760-1762   
   ADJC_S1  1763-1765       ADJC_S2  1766-1768       ADJC_SHI  1769-1771   
   ADJC_T1  1772-1774       ADJC_T2  1775-1777       ADJC_THI  1778-1780   
   ADJC_U1  1781-1783       ADJC_U2  1784-1786       ADJC_UHI  1787-1789   
   BASADC1  1790-1792       BASADC2  1793-1795       BASADCHI  1796-1798   
   BASEC1  1799-1801        BASEC2  1802-1804        BASECHI  1805-1807    
   BASLNC1  1808-1810       BASLNC2  1811-1813       BASLNCHI  1814-1816   
   ADJOFU1  1817-1819       ADJOFU2  1820-1822       ADJOFUHI  1823-1825   
   ADJU_B1  1826-1828       ADJU_B2  1829-1831       ADJU_BHI  1832-1834   
   ADJU_C1  1835-1837       ADJU_C2  1838-1840       ADJU_CHI  1841-1843   
   ADJU_D1  1844-1846       ADJU_D2  1847-1849       ADJU_DHI  1850-1852   
   ADJU_E1  1853-1855       ADJU_E2  1856-1858       ADJU_EHI  1859-1861   
   ADJU_F1  1862-1864       ADJU_F2  1865-1867       ADJU_FHI  1868-1870   
   ADJU_G1  1871-1873       ADJU_G2  1874-1876       ADJU_GHI  1877-1879   
   ADJU_H1  1880-1882       ADJU_H2  1883-1885       ADJU_HHI  1886-1888   
   ADJU_I1  1889-1891       ADJU_I2  1892-1894       ADJU_IHI  1895-1897   
   ADJU_J1  1898-1900       ADJU_J2  1901-1903       ADJU_JHI  1904-1906   
   ADJU_K1  1907-1909       ADJU_K2  1910-1912       ADJU_KHI  1913-1915   
   ADJU_L1  1916-1918       ADJU_L2  1919-1921       ADJU_LHI  1922-1924   
   ADJU_M1  1925-1927       ADJU_M2  1928-1930       ADJU_MHI  1931-1933   
   ADJU_N1  1934-1936       ADJU_N2  1937-1939       ADJU_NHI  1940-1942   
   ADJU_O1  1943-1945       ADJU_O2  1946-1948       ADJU_OHI  1949-1951   
   ADJU_P1  1952-1954       ADJU_P2  1955-1957       ADJU_PHI  1958-1960   
   ADJU_Q1  1961-1963       ADJU_Q2  1964-1966       ADJU_QHI  1967-1969   
   ADJU_R1  1970-1972       ADJU_R2  1973-1975       ADJU_RHI  1976-1978   
   ADJU_S1  1979-1981       ADJU_S2  1982-1984       ADJU_SHI  1985-1987   
   ADJU_T1  1988-1990       ADJU_T2  1991-1993       ADJU_THI  1994-1996   
   ADJU_U1  1997-1999       ADJU_U2  2000-2002       ADJU_UHI  2003-2005   
   BASADU1  2006-2008       BASADU2  2009-2011       BASADUHI  2012-2014   
   BASEU1  2015-2017        BASEU2  2018-2020        BASEUHI  2021-2023    
   BASLNU1  2024-2026       BASLNU2  2027-2029       BASLNUHI  2030-2032   
   ADJL_B1 $ 2033           ADJL_B2 $ 2034           ADJL_BHI $ 2035       
   ADJL_C1 $ 2036-2037      ADJL_C2 $ 2038           ADJL_CHI $ 2039-2040  
   ADJL_D1 $ 2041           ADJL_D2 $ 2042           ADJL_DHI $ 2043       
   ADJL_E1 $ 2044           ADJL_E2 $ 2045           ADJL_EHI $ 2046       
   ADJL_F1 $ 2047           ADJL_F2 $ 2048           ADJL_FHI $ 2049       
   ADJL_G1 $ 2050           ADJL_G2 $ 2051           ADJL_GHI $ 2052       
   ADJL_H1 $ 2053-2054      ADJL_H2 $ 2055           ADJL_HHI $ 2056-2057  
   ADJL_I1 $ 2058           ADJL_I2 $ 2059           ADJL_IHI $ 2060       
   ADJL_J1 $ 2061           ADJL_J2 $ 2062           ADJL_JHI $ 2063       
   ADJL_K1 $ 2064           ADJL_K2 $ 2065           ADJL_KHI $ 2066       
   ADJL_L1 $ 2067           ADJL_L2 $ 2068           ADJL_LHI $ 2069       
   ADJL_M1 $ 2070           ADJL_M2 $ 2071           ADJL_MHI $ 2072       
   ADJL_N1 $ 2073           ADJL_N2 $ 2074           ADJL_NHI $ 2075       
   ADJL_O1 $ 2076           ADJL_O2 $ 2077           ADJL_OHI $ 2078       
   ADJL_P1 $ 2079           ADJL_P2 $ 2080           ADJL_PHI $ 2081       
   ADJL_Q1 $ 2082           ADJL_Q2 $ 2083           ADJL_QHI $ 2084       
   ADJL_R1 $ 2085           ADJL_R2 $ 2086           ADJL_RHI $ 2087       
   ADJL_S1 $ 2088           ADJL_S2 $ 2089           ADJL_SHI $ 2090       
   ADJL_T1 $ 2091           ADJL_T2 $ 2092           ADJL_THI $ 2093       
   ADJL_U1 $ 2094           ADJL_U2 $ 2095           ADJL_UHI $ 2096       
   BASEL1 $ 2097            BASEL2 $ 2098            BASELHI $ 2099        
   ADSL_B1 $ 2100           ADSL_B2 $ 2101           ADSL_BHI $ 2102       
   ADSL_C1 $ 2103-2104      ADSL_C2 $ 2105           ADSL_CHI $ 2106-2107  
   ADSL_D1 $ 2108           ADSL_D2 $ 2109           ADSL_DHI $ 2110       
   ADSL_E1 $ 2111           ADSL_E2 $ 2112           ADSL_EHI $ 2113       
   ADSL_F1 $ 2114           ADSL_F2 $ 2115           ADSL_FHI $ 2116       
   ADSL_G1 $ 2117           ADSL_G2 $ 2118           ADSL_GHI $ 2119       
   ADSL_H1 $ 2120-2121      ADSL_H2 $ 2122           ADSL_HHI $ 2123-2124  
   ADSL_I1 $ 2125           ADSL_I2 $ 2126           ADSL_IHI $ 2127       
   ADSL_J1 $ 2128           ADSL_J2 $ 2129           ADSL_JHI $ 2130       
   ADSL_K1 $ 2131           ADSL_K2 $ 2132           ADSL_KHI $ 2133       
   ADSL_L1 $ 2134           ADSL_L2 $ 2135           ADSL_LHI $ 2136       
   ADSL_M1 $ 2137           ADSL_M2 $ 2138           ADSL_MHI $ 2139       
   ADSL_N1 $ 2140           ADSL_N2 $ 2141           ADSL_NHI $ 2142       
   ADSL_O1 $ 2143           ADSL_O2 $ 2144           ADSL_OHI $ 2145       
   ADSL_P1 $ 2146           ADSL_P2 $ 2147           ADSL_PHI $ 2148       
   ADSL_Q1 $ 2149           ADSL_Q2 $ 2150           ADSL_QHI $ 2151       
   ADSL_R1 $ 2152           ADSL_R2 $ 2153           ADSL_RHI $ 2154       
   ADSL_S1 $ 2155           ADSL_S2 $ 2156           ADSL_SHI $ 2157       
   ADSL_T1 $ 2158           ADSL_T2 $ 2159           ADSL_THI $ 2160       
   ADSL_U1 $ 2161           ADSL_U2 $ 2162           ADSL_UHI $ 2163       
   BASESL1 $ 2164           BASESL2 $ 2165           BASESLHI $ 2166       
   ADRL_B1 $ 2167           ADRL_B2 $ 2168           ADRL_BHI $ 2169       
   ADRL_C1 $ 2170-2171      ADRL_C2 $ 2172           ADRL_CHI $ 2173-2174  
   ADRL_D1 $ 2175           ADRL_D2 $ 2176           ADRL_DHI $ 2177       
   ADRL_E1 $ 2178           ADRL_E2 $ 2179           ADRL_EHI $ 2180       
   ADRL_F1 $ 2181           ADRL_F2 $ 2182           ADRL_FHI $ 2183       
   ADRL_G1 $ 2184           ADRL_G2 $ 2185           ADRL_GHI $ 2186       
   ADRL_H1 $ 2187           ADRL_H2 $ 2188           ADRL_HHI $ 2189       
   ADRL_I1 $ 2190           ADRL_I2 $ 2191           ADRL_IHI $ 2192       
   ADRL_J1 $ 2193           ADRL_J2 $ 2194           ADRL_JHI $ 2195       
   ADRL_K1 $ 2196           ADRL_K2 $ 2197           ADRL_KHI $ 2198       
   ADRL_L1 $ 2199           ADRL_L2 $ 2200           ADRL_LHI $ 2201       
   ADRL_M1 $ 2202           ADRL_M2 $ 2203           ADRL_MHI $ 2204       
   ADRL_N1 $ 2205           ADRL_N2 $ 2206           ADRL_NHI $ 2207       
   ADRL_O1 $ 2208           ADRL_O2 $ 2209           ADRL_OHI $ 2210       
   ADRL_P1 $ 2211           ADRL_P2 $ 2212           ADRL_PHI $ 2213       
   ADRL_Q1 $ 2214           ADRL_Q2 $ 2215           ADRL_QHI $ 2216       
   ADRL_R1 $ 2217           ADRL_R2 $ 2218           ADRL_RHI $ 2219       
   ADRL_S1 $ 2220           ADRL_S2 $ 2221           ADRL_SHI $ 2222       
   ADRL_T1 $ 2223           ADRL_T2 $ 2224           ADRL_THI $ 2225       
   ADRL_U1 $ 2226           ADRL_U2 $ 2227           ADRL_UHI $ 2228       
   BASERL1 $ 2229           BASERL2 $ 2230           BASERLHI $ 2231       
   ADCL_B1 $ 2232           ADCL_B2 $ 2233           ADCL_BHI $ 2234       
   ADCL_C1 $ 2235           ADCL_C2 $ 2236           ADCL_CHI $ 2237       
   ADCL_D1 $ 2238           ADCL_D2 $ 2239           ADCL_DHI $ 2240       
   ADCL_E1 $ 2241           ADCL_E2 $ 2242           ADCL_EHI $ 2243       
   ADCL_F1 $ 2244           ADCL_F2 $ 2245           ADCL_FHI $ 2246       
   ADCL_G1 $ 2247           ADCL_G2 $ 2248           ADCL_GHI $ 2249       
   ADCL_H1 $ 2250           ADCL_H2 $ 2251           ADCL_HHI $ 2252       
   ADCL_I1 $ 2253           ADCL_I2 $ 2254           ADCL_IHI $ 2255       
   ADCL_J1 $ 2256           ADCL_J2 $ 2257           ADCL_JHI $ 2258       
   ADCL_K1 $ 2259           ADCL_K2 $ 2260           ADCL_KHI $ 2261       
   ADCL_L1 $ 2262           ADCL_L2 $ 2263           ADCL_LHI $ 2264       
   ADCL_M1 $ 2265           ADCL_M2 $ 2266           ADCL_MHI $ 2267       
   ADCL_N1 $ 2268           ADCL_N2 $ 2269           ADCL_NHI $ 2270       
   ADCL_O1 $ 2271           ADCL_O2 $ 2272           ADCL_OHI $ 2273       
   ADCL_P1 $ 2274           ADCL_P2 $ 2275           ADCL_PHI $ 2276       
   ADCL_Q1 $ 2277           ADCL_Q2 $ 2278           ADCL_QHI $ 2279       
   ADCL_R1 $ 2280           ADCL_R2 $ 2281           ADCL_RHI $ 2282       
   ADCL_S1 $ 2283           ADCL_S2 $ 2284           ADCL_SHI $ 2285       
   ADCL_T1 $ 2286           ADCL_T2 $ 2287           ADCL_THI $ 2288       
   ADCL_U1 $ 2289           ADCL_U2 $ 2290           ADCL_UHI $ 2291       
   BASECL1 $ 2292           BASECL2 $ 2293           BASECLHI $ 2294       
   ADUL_B1 $ 2295           ADUL_B2 $ 2296           ADUL_BHI $ 2297       
   ADUL_C1 $ 2298           ADUL_C2 $ 2299           ADUL_CHI $ 2300       
   ADUL_D1 $ 2301           ADUL_D2 $ 2302           ADUL_DHI $ 2303       
   ADUL_E1 $ 2304           ADUL_E2 $ 2305           ADUL_EHI $ 2306       
   ADUL_F1 $ 2307           ADUL_F2 $ 2308           ADUL_FHI $ 2309       
   ADUL_G1 $ 2310           ADUL_G2 $ 2311           ADUL_GHI $ 2312       
   ADUL_H1 $ 2313           ADUL_H2 $ 2314           ADUL_HHI $ 2315       
   ADUL_I1 $ 2316           ADUL_I2 $ 2317           ADUL_IHI $ 2318       
   ADUL_J1 $ 2319           ADUL_J2 $ 2320           ADUL_JHI $ 2321       
   ADUL_K1 $ 2322           ADUL_K2 $ 2323           ADUL_KHI $ 2324       
   ADUL_L1 $ 2325           ADUL_L2 $ 2326           ADUL_LHI $ 2327       
   ADUL_M1 $ 2328           ADUL_M2 $ 2329           ADUL_MHI $ 2330       
   ADUL_N1 $ 2331           ADUL_N2 $ 2332           ADUL_NHI $ 2333       
   ADUL_O1 $ 2334           ADUL_O2 $ 2335           ADUL_OHI $ 2336       
   ADUL_P1 $ 2337           ADUL_P2 $ 2338           ADUL_PHI $ 2339       
   ADUL_Q1 $ 2340           ADUL_Q2 $ 2341           ADUL_QHI $ 2342       
   ADUL_R1 $ 2343           ADUL_R2 $ 2344           ADUL_RHI $ 2345       
   ADUL_S1 $ 2346           ADUL_S2 $ 2347           ADUL_SHI $ 2348       
   ADUL_T1 $ 2349           ADUL_T2 $ 2350           ADUL_THI $ 2351       
   ADUL_U1 $ 2352           ADUL_U2 $ 2353           ADUL_UHI $ 2354       
   BASEUL1 $ 2355           BASEUL2 $ 2356           BASEULHI $ 2357       
   GDLINE1 $ 2358-2362      GDLINE2 $ 2363-2367      GDSTAT1 $ 2368-2372   
   GDSTAT2 $ 2373-2377      GDREF1 $ 2378-2382       GDREF2 $ 2383         
   GDCROS1 $ 2384-2388      GDCROS2 $ 2389           GDUNDR1 $ 2390        
   GDUNDR2 $ 2391           GDLINEHI $ 2392-2396     GDSTATHI $ 2397-2401  
   GDREFHI $ 2402-2406      GDCROSHI $ 2407-2411     GDUNDRHI $ 2412       
   STA1_1 $ 2413-2424       STA1_2 $ 2425-2433       STA1_3 $ 2434-2442    
   STA1_4 $ 2443-2451       STA1_5 $ 2452-2460       STA1_6 $ 2461-2469    
   STA1_7 $ 2470-2478       STA1_8 $ 2479-2487       STA1_9 $ 2488-2496    
   STA1_10 $ 2497-2505      STA1_11 $ 2506-2514      STA1_12 $ 2515-2523   
   STA1_13 $ 2524-2532      STA1_14 $ 2533-2541      STA1_15 $ 2542-2550   
   STA1_16 $ 2551-2559      STA1_17 $ 2560-2568      STA1_18 $ 2569-2577   
   STA1_19 $ 2578-2586      STA1_20 $ 2587-2595      STA1_21 $ 2596-2604   
   STA1_22 $ 2605-2613      STA1_23 $ 2614-2622      STA1_24 $ 2623-2631   
   STA1_25 $ 2632-2640      STA1_26 $ 2641-2649      STA1_27 $ 2650-2658   
   STA1_28 $ 2659-2667      STA1_29 $ 2668-2676      STA1_30 $ 2677-2685   
   STA1_31 $ 2686-2694      STA1_32 $ 2695-2700      STA1_33 $ 2701-2706   
   STA1_34 $ 2707-2712      STA1_35 $ 2713-2718      STA1_36 $ 2719-2724   
   STA1_37 $ 2725-2730      STA1_38 $ 2731-2736      STA1_39 $ 2737-2742   
   STA1_40 $ 2743-2748      STA1_41 $ 2749-2755      STA1_42 $ 2756-2762   
   STA1_43 $ 2763-2769      STA1_44 $ 2770-2776      STA1_45 $ 2777-2783   
   STA1_46 $ 2784-2790      STA1_47 $ 2791-2798      STA2_1 $ 2799-2809    
   STA2_2 $ 2810-2818       STA2_3 $ 2819-2825       STA2_4 $ 2826-2832    
   STA2_5 $ 2833-2839       STA2_6 $ 2840-2846       STA2_7 $ 2847-2853    
   STA2_8 $ 2854-2860       STA2_9 $ 2861            STA2_10 $ 2862        
   STA2_11 $ 2863           STA2_12 $ 2864           STA2_13 $ 2865        
   STA2_14 $ 2866           STA2_15 $ 2867           STA2_16 $ 2868        
   STA2_17 $ 2869           STA2_18 $ 2870           STA2_19 $ 2871        
   STA2_20 $ 2872           STA2_21 $ 2873           STA2_22 $ 2874        
   STA2_23 $ 2875           STA2_24 $ 2876           STA2_25 $ 2877        
   STA2_26 $ 2878           STA2_27 $ 2879           STA2_28 $ 2880        
   STA2_29 $ 2881           STA2_30 $ 2882           STA2_31 $ 2883        
   STA2_32 $ 2884           STA2_33 $ 2885           STA2_34 $ 2886        
   STA2_35 $ 2887           STA2_36 $ 2888           STA2_37 $ 2889        
   STA2_38 $ 2890           STA2_39 $ 2891           STA2_40 $ 2892        
   STA2_41 $ 2893           STA2_42 $ 2894           STA2_43 $ 2895        
   STA2_44 $ 2896           STA2_45 $ 2897           STA2_46 $ 2898        
   STA2_47 $ 2899           STA3_1 $ 2900-2907       STA3_2 $ 2908         
   STA3_3 $ 2909            STA3_4 $ 2910            STA3_5 $ 2911         
   STA3_6 $ 2912            STA3_7 $ 2913            STA3_8 $ 2914         
   STA3_9 $ 2915            STA3_10 $ 2916           STA3_11 $ 2917        
   STA3_12 $ 2918           STA3_13 $ 2919           STA3_14 $ 2920        
   STA3_15 $ 2921           STA3_16 $ 2922           STA3_17 $ 2923        
   STA3_18 $ 2924           STA3_19 $ 2925           STA3_20 $ 2926        
   STA3_21 $ 2927           STA3_22 $ 2928           STA3_23 $ 2929        
   STA3_24 $ 2930           STA3_25 $ 2931           STA3_26 $ 2932        
   STA3_27 $ 2933           STA3_28 $ 2934           STA3_29 $ 2935        
   STA3_30 $ 2936           STA3_31 $ 2937           STA3_32 $ 2938        
   STA3_33 $ 2939           STA3_34 $ 2940           STA3_35 $ 2941        
   STA3_36 $ 2942           STA3_37 $ 2943           STA3_38 $ 2944        
   STA3_39 $ 2945           STA3_40 $ 2946           STA3_41 $ 2947        
   STA3_42 $ 2948           STA3_43 $ 2949           STA3_44 $ 2950        
   STA3_45 $ 2951           STA3_46 $ 2952           STA3_47 $ 2953        
   NWSTAT1 $ 2954-2965      NWSTAT2 $ 2966-2976      NWSTAT3 $ 2977-2985   
   NWSTAT4 $ 2986-2994      NWSTAT5 $ 2995-3002      NWSTAT6 $ 3003-3010   
   NWSTAT7 $ 3011-3017      TTSC1_1 $ 3018-3023      TTSC1_2 $ 3024-3029   
   TTSC1_3 $ 3030-3036      TTSC1_4 $ 3037-3042      TTSC1_5 $ 3043-3048   
   TTSC1_6 $ 3049-3054      TTSC1_7 $ 3055-3060      TTSC1_8 $ 3061-3066   
   TTSC1_9 $ 3067-3072      TTSC1_10 $ 3073-3078     TTSC1_11 $ 3079-3084  
   TTSC1_12 $ 3085-3090     TTSC1_13 $ 3091-3096     TTSC1_14 $ 3097-3102  
   TTSC1_15 $ 3103-3108     TTSC1_16 $ 3109-3114     TTSC1_17 $ 3115-3120  
   TTSC1_18 $ 3121-3126     TTSC1_19 $ 3127-3132     TTSC1_20 $ 3133-3138  
   TTSC1_21 $ 3139-3144     TTSC1_22 $ 3145-3150     TTSC1_23 $ 3151-3156  
   TTSC1_24 $ 3157-3162     TTSC1_25 $ 3163-3168     TTSC1_26 $ 3169-3174  
   TTSC1_27 $ 3175-3180     TTSC1_28 $ 3181-3186     TTSC1_29 $ 3187-3192  
   TTSC1_30 $ 3193-3198     TTSC1_31 $ 3199-3204     TTSC1_32 $ 3205-3210  
   TTSC1_33 $ 3211-3216     TTSC1_34 $ 3217-3222     TTSC1_35 $ 3223-3228  
   TTSC1_36 $ 3229-3234     TTSC1_37 $ 3235-3240     TTSC1_38 $ 3241-3246  
   TTSC1_39 $ 3247-3252     TTSC1_40 $ 3253-3258     TTSC1_41 $ 3259-3263  
   TTSC1_42 $ 3264-3268     TTSC1_43 $ 3269-3273     TTSC1_44 $ 3274-3278  
   TTSC1_45 $ 3279-3283     TTSC1_46 $ 3284-3288     TTSC1_47 $ 3289-3293  
   TTSC2_1 $ 3294-3301      TTSC2_2 $ 3302-3307      TTSC2_3 $ 3308-3312   
   TTSC2_4 $ 3313-3317      TTSC2_5 $ 3318-3322      TTSC2_6 $ 3323-3328   
   TTSC2_7 $ 3329-3334      TTSC2_8 $ 3335-3340      TTSC2_9 $ 3341        
   TTSC2_10 $ 3342          TTSC2_11 $ 3343          TTSC2_12 $ 3344       
   TTSC2_13 $ 3345          TTSC2_14 $ 3346          TTSC2_15 $ 3347       
   TTSC2_16 $ 3348          TTSC2_17 $ 3349          TTSC2_18 $ 3350       
   TTSC2_19 $ 3351          TTSC2_20 $ 3352          TTSC2_21 $ 3353       
   TTSC2_22 $ 3354          TTSC2_23 $ 3355          TTSC2_24 $ 3356       
   TTSC2_25 $ 3357          TTSC2_26 $ 3358          TTSC2_27 $ 3359       
   TTSC2_28 $ 3360          TTSC2_29 $ 3361          TTSC2_30 $ 3362       
   TTSC2_31 $ 3363          TTSC2_32 $ 3364          TTSC2_33 $ 3365       
   TTSC2_34 $ 3366          TTSC2_35 $ 3367          TTSC2_36 $ 3368       
   TTSC2_37 $ 3369          TTSC2_38 $ 3370          TTSC2_39 $ 3371       
   TTSC2_40 $ 3372          TTSC2_41 $ 3373          TTSC2_42 $ 3374       
   TTSC2_43 $ 3375          TTSC2_44 $ 3376          TTSC2_45 $ 3377       
   TTSC2_46 $ 3378          TTSC2_47 $ 3379          TTSC3_1 $ 3380-3385   
   TTSC3_2 $ 3386           TTSC3_3 $ 3387           TTSC3_4 $ 3388        
   TTSC3_5 $ 3389           TTSC3_6 $ 3390           TTSC3_7 $ 3391        
   TTSC3_8 $ 3392           TTSC3_9 $ 3393           TTSC3_10 $ 3394       
   TTSC3_11 $ 3395          TTSC3_12 $ 3396          TTSC3_13 $ 3397       
   TTSC3_14 $ 3398          TTSC3_15 $ 3399          TTSC3_16 $ 3400       
   TTSC3_17 $ 3401          TTSC3_18 $ 3402          TTSC3_19 $ 3403       
   TTSC3_20 $ 3404          TTSC3_21 $ 3405          TTSC3_22 $ 3406       
   TTSC3_23 $ 3407          TTSC3_24 $ 3408          TTSC3_25 $ 3409       
   TTSC3_26 $ 3410          TTSC3_27 $ 3411          TTSC3_28 $ 3412       
   TTSC3_29 $ 3413          TTSC3_30 $ 3414          TTSC3_31 $ 3415       
   TTSC3_32 $ 3416          TTSC3_33 $ 3417          TTSC3_34 $ 3418       
   TTSC3_35 $ 3419          TTSC3_36 $ 3420          TTSC3_37 $ 3421       
   TTSC3_38 $ 3422          TTSC3_39 $ 3423          TTSC3_40 $ 3424       
   TTSC3_41 $ 3425          TTSC3_42 $ 3426          TTSC3_43 $ 3427       
   TTSC3_44 $ 3428          TTSC3_45 $ 3429          TTSC3_46 $ 3430       
   TTSC3_47 $ 3431          SMAX1  3432-3439         SMAX2  3440-3447      
   SMAX3  3448-3455         SMAX4  3456-3463         SMAX5  3464-3471      
   SMAX6  3472-3479         SMAX7  3480-3487         SMAX8  3488-3495      
   SMAX9  3496-3503         SMAX10  3504-3511        SMAX11  3512-3519     
   SMAX12  3520-3527        SMAX13  3528-3535        SMAX14  3536-3543     
   SMAX15  3544-3551        SMAX16  3552-3559        SMAX17  3560-3567     
   SMAX18  3568-3575        SMAX19  3576-3583        SMAX20  3584-3591     
   SMAX21  3592-3599        SMAX22  3600-3607        SMAX23  3608-3615     
   SMAX24  3616-3623        SMAX25  3624-3631        SMAX26  3632-3639     
   SMAX27  3640-3647        SMAX28  3648-3655        SMAX29  3656-3663     
   SMAX30  3664-3671        SMAX31  3672-3679        SMAX32  3680-3687     
   SMAX33  3688-3695        SMAX34  3696-3703        SMAX35  3704-3711     
   SMAX36  3712-3719        SMAX37  3720-3727        SMAX38  3728-3735     
   SMAX39  3736-3743        SMAX40  3744-3751        SMAX41  3752-3759     
   SMAX42  3760-3767        SMAX43  3768-3775        SMAX44  3776-3783     
   SMAX45  3784-3791        SMAX46  3792-3799        SMAX47  3800-3807     
   SMIN1  3808-3815         SMIN2  3816-3823         SMIN3  3824-3831      
   SMIN4  3832-3839         SMIN5  3840-3847         SMIN6  3848-3855      
   SMIN7  3856-3863         SMIN8  3864-3871         SMIN9  3872-3879      
   SMIN10  3880-3887        SMIN11  3888-3895        SMIN12  3896-3903     
   SMIN13  3904-3911        SMIN14  3912-3919        SMIN15  3920-3927     
   SMIN16  3928-3935        SMIN17  3936-3943        SMIN18  3944-3951     
   SMIN19  3952-3959        SMIN20  3960-3967        SMIN21  3968-3975     
   SMIN22  3976-3983        SMIN23  3984-3991        SMIN24  3992-3999     
   SMIN25  4000-4007        SMIN26  4008-4015        SMIN27  4016-4023     
   SMIN28  4024-4031        SMIN29  4032-4039        SMIN30  4040-4047     
   SMIN31  4048-4055        SMIN32  4056-4063        SMIN33  4064-4071     
   SMIN34  4072-4079        SMIN35  4080-4087        SMIN36  4088-4095     
   SMIN37  4096-4103        SMIN38  4104-4111        SMIN39  4112-4119     
   SMIN40  4120-4127        SMIN41  4128-4135        SMIN42  4136-4143     
   SMIN43  4144-4151        SMIN44  4152-4159        SMIN45  4160-4167     
   SMIN46  4168-4175        SMIN47  4176-4183        RETEXT1 $ 4184-4222   
   RETEXT2 $ 4223           RETEXT3 $ 4224           RETEXT4 $ 4225-4243   
   RETEXT5 $ 4244           RETEXT6 $ 4245         ;                       

LENGTH
   ACCEPT 3                 BUSCLAS 4                CANTPAY 3             
   CCULPSCO 3               CH2APP 3                 CH8FINGD 3            
   CMSRVORD 3               COFI 3                   COMPLY 3              
   COMPLYPR 3               CRIMPURP 3               DETBFINE 3            
   DISPOSIT 3               EMPLOYNM 3               FCULPSCO 3            
   FRAUDTYP 3               FINSTDS 3                HISTORY 3             
   HSMISCND 3               INCORLOC 3               INCORPYR 4            
   INDICT 3                 INPLEA1 3                INPLEA2 3             
   INPLEA3 3                INPLEA4 3                INPLEA5 3             
   INPLEA6 3                INPLEA7 3                INPLEA8 3             
   INPLEA9 3                INPLEA10 3               INPLEA11 3            
   INPLEA12 3               INNOPL1 3                INNOPL2 3             
   INNOPL3 3                INNOPL4 3                INNOPL5 3             
   INNOPL6 3                INNOPL7 3                INNOPL8 3             
   INNOPL9 3                INNOPL10 3               INNOPL11 3            
   INNOPL12 3               JANDC 3                  NEWCNVTN 3            
   NOCOMP 3                 NOCOUNTS 3               NOREAVAR 3            
   NOUSTAT 3                OBSTRUCT 3               OFFLVL 3              
   ORDERCE 3                ORGTYPE 3                OWNSTRCT 3            
   PLEA 3                   PRIMOFF 3                PRCIVIL 3             
   PRCRIME 3                PROBATN 3                PROBMON 3             
   PSR 3                    QUARTER 3                REAS1 4               
   REAS2 4                  REAS3 3                  REAS4 4               
   REAS5 3                  REAS6 3                  REASON3 3             
   REASON4 3                REASONS 3                REMEDORD 3            
   SELFREP 3                SENTRNGE 3               SOURCES 3             
   TOLERNCE 3               TYPEOTHS 3               VICTNOTE 3            
   VIOLATE 3                AMENDYR 4                SENTYR 4              
   BASEFINE 6               COSTASSM 4               DISGORGE 3            
   FINOFFST 3               FORFEITR 6               GLFINMAX 6            
   GLFINMIN 6               STATMIN 3                STATMAX 6             
   RESTCAT 3                FINECAT 3                SUSFNCAT 3            
   LCAT1 3                  LCAT2 3                  LCATHI 3              
   LCATS1 3                 LCATS2 3                 LCATSHI 3             
   LCATR1 3                 LCATR2 3                 LCATRHI 3             
   LCATC1 3                 LCATC2 3                 LCATCHI 3             
   LCATU1 3                 LCATU2 3                 LCATUHI 3             
   CPIDN 6                  ADJOFL1 3                ADJOFL2 3             
   ADJOFLHI 3               ADJ_B1 3                 ADJ_B2 3              
   ADJ_BHI 3                ADJ_C1 3                 ADJ_C2 3              
   ADJ_CHI 3                ADJ_D1 3                 ADJ_D2 3              
   ADJ_DHI 3                ADJ_E1 3                 ADJ_E2 3              
   ADJ_EHI 3                ADJ_F1 3                 ADJ_F2 3              
   ADJ_FHI 3                ADJ_G1 3                 ADJ_G2 3              
   ADJ_GHI 3                ADJ_H1 3                 ADJ_H2 3              
   ADJ_HHI 3                ADJ_I1 3                 ADJ_I2 3              
   ADJ_IHI 3                ADJ_J1 3                 ADJ_J2 3              
   ADJ_JHI 3                ADJ_K1 3                 ADJ_K2 3              
   ADJ_KHI 3                ADJ_L1 3                 ADJ_L2 3              
   ADJ_LHI 3                ADJ_M1 3                 ADJ_M2 3              
   ADJ_MHI 3                ADJ_N1 3                 ADJ_N2 3              
   ADJ_NHI 3                ADJ_O1 3                 ADJ_O2 3              
   ADJ_OHI 3                ADJ_P1 3                 ADJ_P2 3              
   ADJ_PHI 3                ADJ_Q1 3                 ADJ_Q2 3              
   ADJ_QHI 3                ADJ_R1 3                 ADJ_R2 3              
   ADJ_RHI 3                ADJ_S1 3                 ADJ_S2 3              
   ADJ_SHI 3                ADJ_T1 3                 ADJ_T2 3              
   ADJ_THI 3                ADJ_U1 3                 ADJ_U2 3              
   ADJ_UHI 3                BASADJ1 3                BASADJ2 3             
   BASADJHI 3               BASE1 3                  BASE2 3               
   BASEHI 3                 BASLN1 3                 BASLN2 3              
   BASLNHI 3                ADJOFS1 3                ADJOFS2 3             
   ADJOFSHI 3               ADJS_B1 3                ADJS_B2 3             
   ADJS_BHI 3               ADJS_C1 3                ADJS_C2 3             
   ADJS_CHI 3               ADJS_D1 3                ADJS_D2 3             
   ADJS_DHI 3               ADJS_E1 3                ADJS_E2 3             
   ADJS_EHI 3               ADJS_F1 3                ADJS_F2 3             
   ADJS_FHI 3               ADJS_G1 3                ADJS_G2 3             
   ADJS_GHI 3               ADJS_H1 3                ADJS_H2 3             
   ADJS_HHI 3               ADJS_I1 3                ADJS_I2 3             
   ADJS_IHI 3               ADJS_J1 3                ADJS_J2 3             
   ADJS_JHI 3               ADJS_K1 3                ADJS_K2 3             
   ADJS_KHI 3               ADJS_L1 3                ADJS_L2 3             
   ADJS_LHI 3               ADJS_M1 3                ADJS_M2 3             
   ADJS_MHI 3               ADJS_N1 3                ADJS_N2 3             
   ADJS_NHI 3               ADJS_O1 3                ADJS_O2 3             
   ADJS_OHI 3               ADJS_P1 3                ADJS_P2 3             
   ADJS_PHI 3               ADJS_Q1 3                ADJS_Q2 3             
   ADJS_QHI 3               ADJS_R1 3                ADJS_R2 3             
   ADJS_RHI 3               ADJS_S1 3                ADJS_S2 3             
   ADJS_SHI 3               ADJS_T1 3                ADJS_T2 3             
   ADJS_THI 3               ADJS_U1 3                ADJS_U2 3             
   ADJS_UHI 3               BASADS1 3                BASADS2 3             
   BASADSHI 3               BASES1 3                 BASES2 3              
   BASESHI 3                BASLNS1 3                BASLNS2 3             
   BASLNSHI 3               ADJOFR1 3                ADJOFR2 3             
   ADJOFRHI 3               ADJR_B1 3                ADJR_B2 3             
   ADJR_BHI 3               ADJR_C1 3                ADJR_C2 3             
   ADJR_CHI 3               ADJR_D1 3                ADJR_D2 3             
   ADJR_DHI 3               ADJR_E1 3                ADJR_E2 3             
   ADJR_EHI 3               ADJR_F1 3                ADJR_F2 3             
   ADJR_FHI 3               ADJR_G1 3                ADJR_G2 3             
   ADJR_GHI 3               ADJR_H1 3                ADJR_H2 3             
   ADJR_HHI 3               ADJR_I1 3                ADJR_I2 3             
   ADJR_IHI 3               ADJR_J1 3                ADJR_J2 3             
   ADJR_JHI 3               ADJR_K1 3                ADJR_K2 3             
   ADJR_KHI 3               ADJR_L1 3                ADJR_L2 3             
   ADJR_LHI 3               ADJR_M1 3                ADJR_M2 3             
   ADJR_MHI 3               ADJR_N1 3                ADJR_N2 3             
   ADJR_NHI 3               ADJR_O1 3                ADJR_O2 3             
   ADJR_OHI 3               ADJR_P1 3                ADJR_P2 3             
   ADJR_PHI 3               ADJR_Q1 3                ADJR_Q2 3             
   ADJR_QHI 3               ADJR_R1 3                ADJR_R2 3             
   ADJR_RHI 3               ADJR_S1 3                ADJR_S2 3             
   ADJR_SHI 3               ADJR_T1 3                ADJR_T2 3             
   ADJR_THI 3               ADJR_U1 3                ADJR_U2 3             
   ADJR_UHI 3               BASADR1 3                BASADR2 3             
   BASADRHI 3               BASER1 3                 BASER2 3              
   BASERHI 3                BASLNR1 3                BASLNR2 3             
   BASLNRHI 3               ADJOFC1 3                ADJOFC2 3             
   ADJOFCHI 3               ADJC_B1 3                ADJC_B2 3             
   ADJC_BHI 3               ADJC_C1 3                ADJC_C2 3             
   ADJC_CHI 3               ADJC_D1 3                ADJC_D2 3             
   ADJC_DHI 3               ADJC_E1 3                ADJC_E2 3             
   ADJC_EHI 3               ADJC_F1 3                ADJC_F2 3             
   ADJC_FHI 3               ADJC_G1 3                ADJC_G2 3             
   ADJC_GHI 3               ADJC_H1 3                ADJC_H2 3             
   ADJC_HHI 3               ADJC_I1 3                ADJC_I2 3             
   ADJC_IHI 3               ADJC_J1 3                ADJC_J2 3             
   ADJC_JHI 3               ADJC_K1 3                ADJC_K2 3             
   ADJC_KHI 3               ADJC_L1 3                ADJC_L2 3             
   ADJC_LHI 3               ADJC_M1 3                ADJC_M2 3             
   ADJC_MHI 3               ADJC_N1 3                ADJC_N2 3             
   ADJC_NHI 3               ADJC_O1 3                ADJC_O2 3             
   ADJC_OHI 3               ADJC_P1 3                ADJC_P2 3             
   ADJC_PHI 3               ADJC_Q1 3                ADJC_Q2 3             
   ADJC_QHI 3               ADJC_R1 3                ADJC_R2 3             
   ADJC_RHI 3               ADJC_S1 3                ADJC_S2 3             
   ADJC_SHI 3               ADJC_T1 3                ADJC_T2 3             
   ADJC_THI 3               ADJC_U1 3                ADJC_U2 3             
   ADJC_UHI 3               BASADC1 3                BASADC2 3             
   BASADCHI 3               BASEC1 3                 BASEC2 3              
   BASECHI 3                BASLNC1 3                BASLNC2 3             
   BASLNCHI 3               ADJOFU1 3                ADJOFU2 3             
   ADJOFUHI 3               ADJU_B1 3                ADJU_B2 3             
   ADJU_BHI 3               ADJU_C1 3                ADJU_C2 3             
   ADJU_CHI 3               ADJU_D1 3                ADJU_D2 3             
   ADJU_DHI 3               ADJU_E1 3                ADJU_E2 3             
   ADJU_EHI 3               ADJU_F1 3                ADJU_F2 3             
   ADJU_FHI 3               ADJU_G1 3                ADJU_G2 3             
   ADJU_GHI 3               ADJU_H1 3                ADJU_H2 3             
   ADJU_HHI 3               ADJU_I1 3                ADJU_I2 3             
   ADJU_IHI 3               ADJU_J1 3                ADJU_J2 3             
   ADJU_JHI 3               ADJU_K1 3                ADJU_K2 3             
   ADJU_KHI 3               ADJU_L1 3                ADJU_L2 3             
   ADJU_LHI 3               ADJU_M1 3                ADJU_M2 3             
   ADJU_MHI 3               ADJU_N1 3                ADJU_N2 3             
   ADJU_NHI 3               ADJU_O1 3                ADJU_O2 3             
   ADJU_OHI 3               ADJU_P1 3                ADJU_P2 3             
   ADJU_PHI 3               ADJU_Q1 3                ADJU_Q2 3             
   ADJU_QHI 3               ADJU_R1 3                ADJU_R2 3             
   ADJU_RHI 3               ADJU_S1 3                ADJU_S2 3             
   ADJU_SHI 3               ADJU_T1 3                ADJU_T2 3             
   ADJU_THI 3               ADJU_U1 3                ADJU_U2 3             
   ADJU_UHI 3               BASADU1 3                BASADU2 3             
   BASADUHI 3               BASEU1 3                 BASEU2 3              
   BASEUHI 3                BASLNU1 3                BASLNU2 3             
   BASLNUHI 3               SMAX1 6                  SMAX2 6               
   SMAX3 6                  SMAX4 6                  SMAX5 6               
   SMAX6 6                  SMAX7 6                  SMAX8 6               
   SMAX9 6                  SMAX10 6                 SMAX11 6              
   SMAX12 6                 SMAX13 6                 SMAX14 6              
   SMAX15 6                 SMAX16 6                 SMAX17 6              
   SMAX18 6                 SMAX19 6                 SMAX20 6              
   SMAX21 6                 SMAX22 6                 SMAX23 6              
   SMAX24 6                 SMAX25 6                 SMAX26 6              
   SMAX27 6                 SMAX28 6                 SMAX29 6              
   SMAX30 6                 SMAX31 6                 SMAX32 6              
   SMAX33 6                 SMAX34 6                 SMAX35 6              
   SMAX36 6                 SMAX37 6                 SMAX38 6              
   SMAX39 6                 SMAX40 6                 SMAX41 6              
   SMAX42 6                 SMAX43 6                 SMAX44 6              
   SMAX45 6                 SMAX46 6                 SMAX47 6              
   SMIN1 3                  SMIN2 3                  SMIN3 3               
   SMIN4 3                  SMIN5 3                  SMIN6 3               
   SMIN7 3                  SMIN8 3                  SMIN9 3               
   SMIN10 3                 SMIN11 3                 SMIN12 3              
   SMIN13 3                 SMIN14 3                 SMIN15 3              
   SMIN16 3                 SMIN17 3                 SMIN18 3              
   SMIN19 3                 SMIN20 3                 SMIN21 3              
   SMIN22 3                 SMIN23 3                 SMIN24 3              
   SMIN25 3                 SMIN26 3                 SMIN27 3              
   SMIN28 3                 SMIN29 3                 SMIN30 3              
   SMIN31 3                 SMIN32 3                 SMIN33 3              
   SMIN34 3                 SMIN35 3                 SMIN36 3              
   SMIN37 3                 SMIN38 3                 SMIN39 3              
   SMIN40 3                 SMIN41 3                 SMIN42 3              
   SMIN43 3                 SMIN44 3                 SMIN45 3              
   SMIN46 3                 SMIN47 3 ;

          

RUN ;
