* Encoding: UTF-8.
/*********************************************************************************************************/
/*                                                                                                                                 */
/* This SPSS program will extract the United States Sentencing Commission's                 */
/* Federa Sentencing Of Child Pornography: Non-Production Offenses report file and create */
/*  a SPSS dataset.                                                                                                      */
/*                                                                                                                                 */
/* Prior to running the program you must update the DAT file location in the                       */
/* FILE HANDLE DATA / NAME line to correspond to the location of the file on your           */
/* computer.                                                                                                                 */
/*                                                                                                                                 */
/* You must also update the file output location in the SAVE OUTFILE statement at the     */
/* end of the program to correspond to the folder you want the output file to be located.       */
/*                                                                                                                                 */
/*********************************************************************************************************/

/* The following line should contain the complete path and name of your raw data file */
/* The last line of this file contains the path to your output '.sav' file */

FILE HANDLE DATA / NAME=".\USSC_CP_Non_Prod_Public.dat" ENCODING="CP1252" / LRECL=632 .

DATA LIST FILE=DATA/
   PRODCOND 1-3             POSSOTH 4-11             CHILDMIN 12-19        
   SENTTCAP 20-27           SENSPCAP 28-35           ABUSEMIN 36-38        
   AGE 39-41                BOOKER2 42-44            BOOKERCD 45-47        
   MONACCEP 48-50           MONCIRC 51-53            MONSEX 54-56          
   NEWCIT 57-59             NEWCNVTN 60-62           NEWEDUC 63-65         
   NEWRACE 66-68            SENTIMP 69-71            SENTRNGE 72-74        
   XCRHISSR 75-77           XFOLSOR 78-80            GLMIN 81-96           
   SUPREL 97-112            XMAXSOR 113-116          XMINSOR 117-120       
   TIMSERVM 121-128         TIMSERVD 129-136         ADJ_BHI 137-139       
   ADJ_CHI 140-142          ADJ_DHI 143-145          ADJ_EHI 146-148       
   ADJ_FHI 149-151          ADJ_GHI 152-154          ADJ_HHI 155-157       
   BASEHI 158-160           ADJL_DHI 161 (A)         RECSTREAM 162-169     
   DISTRIBUTE 170-177       DISTSOCIAL 178-185       POSSESSION 186-193    
   PORNTYPE 194-201         PORNTYPE2 202-209        HIDDEN 210-212        
   ENCRYPT 213-215          DARKWEB 216-218          CRYPTO 219-221        
   OTHCONC 222-224          DISTP2P 225-228          DISTCOND 229-231      
   DISTSTREAM 232-235       DISTCLOUD 236-239        DISTWEB 240-243       
   DISTHAND 244-247         RECP2P 248-251           RECSOCIAL 252-255     
   RECCLOUD 256-259         RECWEB 260-263           POSSSEX 264-267       
   POSSCOMP 268-271         POSSPROXY 272-275        POSSGAME 276-279      
   POSSPAPER 280-283        POSSCLOUD 284-287        RECINTERNET 288-295   
   RECCHAT 296-303          DISTCHAT 304-311         POSSVHS 312-319       
   IMAGETOT 320-328         COMMUNITY 329-336        NEWCOND1 337-344      
   NEWCOND2 345-352         NEWCOND3 353-360         NEWCOND4 361-368      
   NEWCOND5 369-376         NEWCOND7 377-384         NEWCOND8 385-392      
   NEWCOND10 393-400        NEWCOND11 401-408        NEWCOND12 409-416     
   NEWCOND13 417-424        NEWCOND14 425-432        NEWCOND15 433-440     
   HASNEWCOND 441-448       POSSGROUP 449-456        MEDIATYPE 457-464     
   SOMECONC 465-472         SOFTWIPE 473-480         POSSPHONETAB 481-488  
   POSSFLASHEXT 489-496     RECTEXTPLUS 497-504      DISTTEXTPLUS 505-512  
   CONVICT1 513-520         CONVICT2 521-528         CONVICT3 529-536      
   CONVICT4 537-544         POSSCOUNT 545-552        STATENHANCE 553-560   
   ANYCHARGEPROD 561-568    ANYCHARGEDIST 569-576    ANYCHARGEREC 577-584  
   HIGHCONV 585-592         COMMCOND 593-600         FN118 601-608         
   MOSTCOMMON_NODIST 609-616   MOSTCOMMON_DIST 617-624   IDNUM 625-632 .       


FORMATS
  SENTTCAP (F9.2) /        SENSPCAP (F9.2) /        GLMIN (F17.12) /       
  SUPREL (F17.12) /        IMAGETOT (F10.2) / .
  
VARIABLE LABELS
   PRODCOND 'Production Conduct'
   POSSOTH 'Possessed via other device or means'
   RECSTREAM 'Received Pornopgrahy via Live Streaming'
   DISTSOCIAL 'Distributed Pornography via Social Media'
   POSSESSION 'Offender Possessed Child Pornography'
   PORNTYPE 'Sentenced As'
   PORNTYPE2 'Sentenced As'
   HIDDEN 'Offender Used Hidden Catalog(s)/folder(s)'
   ENCRYPT 'Offender Used Encryption to facilitate or conceal the offense'
   DARKWEB    'Offender used the dark web to send, receive, possess, or search f' +
   'or files'
   CRYPTO    'Offender used crypto currency to acquire, conceal, or facilitate ' +
   'child pornography'
   OTHCONC    'Offender otherwise attempted to conceal child pornography using t' +
   'echnology'
   DISTP2P 'Offender Distributed Pornography Via P2P'
   DISTCOND 'Distribution Conduct'
   DISTSTREAM 'Distributed Pornography via Live Streaming'
   DISTCLOUD 'Distributed Pornography via cloud or dropbox'
   DISTWEB 'Distributed Pornography via website'
   DISTHAND 'Distributed pornogrpahy hand-to-hand'
   RECP2P 'Offender Received Pornography via P2P'
   RECSOCIAL 'Received Pornography via Social Media'
   RECCLOUD 'Received Pornography via cloud or dropbox'
   RECWEB 'Received Pornography via website'
   POSSSEX 'Sex of victim(s)'
   POSSCOMP 'Possessed on Computer, laptop, or desktop'
   POSSPROXY 'Possessed on proxy server'
   POSSGAME 'Possessed on video game console'
   POSSPAPER    'Possessed on printed paper or magazine containing child pornograp' +
   'hy'
   POSSCLOUD 'Possessed on cloud or dropbox'
   RECINTERNET 'RECINTERNET'
   RECCHAT 'RECCHAT'
   DISTCHAT 'DISTCHAT'
   POSSVHS 'POSSVHS'
   NEWCOND1 'Conviction for sex offense against a minor'
   NEWCOND2 'Revocation for sex offense against a minor'
   NEWCOND3 'Arrest for sex offense against a minor'
   NEWCOND4 'Admission or Allegation of sex offense against a minor'
   NEWCOND5 'Attempted sex offense or travel to commit against a minor'
   NEWCOND7 'Non-contact production offense'
   NEWCOND8 'Solicitation of a minor offense'
   NEWCOND10 'Sent pornography to minors'
   NEWCOND11 'Other non-contact sex offenses'
   NEWCOND12 'Possession/Receipt/Distribution offense'
   NEWCOND13 'Conviction for sex offense against an adult'
   NEWCOND14 'Arrest for sex offense against an adult'
   NEWCOND15 'Allegation or Admission of sex offense against an adult'
   CONVICT1 'Contact conviction minor OR adult'
   CONVICT2 'Non-contact production conviction'
   CONVICT3 'Other non-contact convictions'
   CONVICT4 'P/R/D Conviction'
   HIGHCONV 'Convicted of'
.

SAVE OUTFILE='.\USSC_CP_Non_Prod_Public.sav'.
